#pragma once

#include <inttypes.h>

#define MONACO_WIDTH 5
#define MONACO_HEIGHT 8
#define MONACO_BYTES_PER_CHAR (MONACO_WIDTH*MONACO_HEIGHT/8)

static uint8_t monaco_font[] = {

/*
.....
.....
.....
.....
.....
.....
.....
.....
   */ 0x00,0x00,0x00,0x00,0x00,

/*
#....
#....
#....
#....
#....
.....
#....
.....
  !*/ 0x21,0x84,0x10,0x40,0x00,

/*
#.#..
#.#..
.....
.....
.....
.....
.....
.....
  "*/ 0xa5,0x00,0x00,0x00,0x00,

/*
..##.
..##.
#####
.#.#.
#####
.##..
.##..
.....
  #*/ 0x8c,0x7d,0xf5,0x8d,0x01,

/*
..#..
.####
#.#..
#.#..
.##..
..###
..#.#
####.
  $*/ 0xc4,0x97,0x62,0x38,0x7d,

/*
#...#
##..#
#..#.
..#..
..##.
.#.##
#..#.
.....
  %*/ 0x71,0x26,0xc2,0x74,0x02,

/*
.#...
#.#..
#.#..
.#...
#.##.
#..#.
.###.
.....
  &*/ 0xa2,0x14,0xd1,0x92,0x03,

/*
#....
#....
.....
.....
.....
.....
.....
.....
  '*/ 0x21,0x00,0x00,0x00,0x00,

/*
..#..
.#...
#....
#....
#....
#....
.#...
..#..
  (*/ 0x44,0x84,0x10,0x82,0x20,

/*
#....
.#...
..#..
..#..
..#..
..#..
.#...
#....
  )*/ 0x41,0x10,0x42,0x88,0x08,

/*
.#...
###..
###..
.#...
.....
.....
.....
.....
  **/ 0xe2,0x1c,0x01,0x00,0x00,

/*
..#..
..#..
#####
..#..
..#..
.....
.....
.....
  +*/ 0x84,0x7c,0x42,0x00,0x00,

/*
#....
#....
#....
.....
.....
.....
.....
.....
  ,*/ 0x21,0x04,0x00,0x00,0x00,

/*
###..
.....
.....
.....
.....
.....
.....
.....
  -*/ 0x07,0x00,0x00,0x00,0x00,

/*
#....
.....
.....
.....
.....
.....
.....
.....
  .*/ 0x01,0x00,0x00,0x00,0x00,

/*
...#.
...#.
..#..
.#...
.#...
#....
.....
.....
  /*/ 0x08,0x11,0x21,0x02,0x00,

/*
.##..
#.##.
#.##.
##.#.
##.#.
##.#.
.##..
.....
  0*/ 0xa6,0xb5,0xb5,0x96,0x01,

/*
.#...
##...
.#...
.#...
.#...
.#...
###..
.....
  1*/ 0x62,0x08,0x21,0xc4,0x01,

/*
###..
...#.
...#.
..#..
.#...
#....
####.
.....
  2*/ 0x07,0x21,0x22,0xc2,0x03,

/*
###..
...#.
...#.
.##..
...#.
...#.
###..
.....
  3*/ 0x07,0x21,0x83,0xd0,0x01,

/*
...#.
..##.
.#.#.
#..#.
#####
...#.
...#.
.....
  4*/ 0x88,0xa9,0xf4,0x11,0x02,

/*
####.
#....
###..
...#.
...#.
...#.
###..
.....
  5*/ 0x2f,0x1c,0x84,0xd0,0x01,

/*
.##..
#....
#.#..
##.#.
##.#.
##.#.
.##..
.....
  6*/ 0x26,0x94,0xb5,0x96,0x01,

/*
####.
...#.
...#.
..#..
.##..
.#...
.#...
.....
  7*/ 0x0f,0x21,0x62,0x84,0x00,

/*
.###.
#..#.
#..#.
.##..
#..#.
#..#.
###..
.....
  8*/ 0x2e,0x25,0x93,0xd2,0x01,

/*
.##..
#..#.
#..#.
#..#.
.###.
...#.
.##..
.....
  9*/ 0x26,0xa5,0xe4,0x90,0x01,

/*
#....
.....
.....
.....
#....
.....
.....
.....
  :*/ 0x01,0x00,0x10,0x00,0x00,

/*
#....
.....
.....
.....
#....
#....
#....
.....
  ;*/ 0x01,0x00,0x10,0x42,0x00,

/*
....#
..##.
##...
..##.
....#
.....
.....
.....
  <*/ 0x90,0x0d,0x06,0x01,0x00,

/*
####.
.....
####.
.....
.....
.....
.....
.....
  =*/ 0x0f,0x3c,0x00,0x00,0x00,

/*
#....
.##..
...##
.##..
#....
.....
.....
.....
  >*/ 0xc1,0x60,0x13,0x00,0x00,

/*
###..
..#..
..#..
.#...
.#...
.....
.#...
.....
  ?*/ 0x87,0x10,0x21,0x80,0x00,

/*
.###.
#...#
#.###
##.##
##.##
#.##.
.##..
.....
  @*/ 0x2e,0xf6,0xbd,0x9b,0x01,

/*
.##..
.##..
.##..
.##..
####.
####.
#..#.
.....
  A*/ 0xc6,0x18,0xf3,0x5e,0x02,

/*
##...
#.#..
#.#..
##...
#.#..
#.#..
##...
.....
  B*/ 0xa3,0x94,0x51,0xca,0x00,

/*
.###.
#....
#....
#....
#....
#....
.###.
.....
  C*/ 0x2e,0x84,0x10,0x82,0x03,

/*
###..
#..#.
#..#.
#..#.
#..#.
#..#.
###..
.....
  D*/ 0x27,0xa5,0x94,0xd2,0x01,

/*
####.
#....
#....
####.
#....
#....
####.
.....
  E*/ 0x2f,0x84,0x17,0xc2,0x03,

/*
####.
#....
#....
####.
#....
#....
#....
.....
  F*/ 0x2f,0x84,0x17,0x42,0x00,

/*
.###.
#....
#....
#.##.
#..#.
#..#.
.###.
.....
  G*/ 0x2e,0x84,0x96,0x92,0x03,

/*
#..#.
#..#.
#..#.
####.
#..#.
#..#.
#..#.
.....
  H*/ 0x29,0xa5,0x97,0x52,0x02,

/*
###..
.#...
.#...
.#...
.#...
.#...
###..
.....
  I*/ 0x47,0x08,0x21,0xc4,0x01,

/*
.###.
...#.
...#.
...#.
...#.
...#.
###..
.....
  J*/ 0x0e,0x21,0x84,0xd0,0x01,

/*
#..#.
#..#.
#.#..
##...
#.#..
#.#..
#..#.
.....
  K*/ 0x29,0x95,0x51,0x4a,0x02,

/*
#....
#....
#....
#....
#....
#....
###..
.....
  L*/ 0x21,0x84,0x10,0xc2,0x01,

/*
##.##
##.##
##.##
##.##
###.#
#.#.#
#...#
.....
  M*/ 0x7b,0xef,0x7d,0x6b,0x04,

/*
#..#.
##.#.
##.#.
#.##.
#.##.
#.##.
#..#.
.....
  N*/ 0x69,0xad,0xd6,0x5a,0x02,

/*
.##..
#..#.
#..#.
#..#.
#..#.
#..#.
.##..
.....
  O*/ 0x26,0xa5,0x94,0x92,0x01,

/*
###..
#..#.
#..#.
#..#.
###..
#....
#....
.....
  P*/ 0x27,0xa5,0x74,0x42,0x00,

/*
.##..
#..#.
#..#.
#..#.
#..#.
#..#.
.##..
..#..
  Q*/ 0x26,0xa5,0x94,0x92,0x21,

/*
##...
#.#..
#.#..
##...
##...
#.#..
#.#..
.....
  R*/ 0xa3,0x94,0x31,0x4a,0x01,

/*
###..
#....
#....
.#...
..#..
..#..
###..
.....
  S*/ 0x27,0x04,0x41,0xc8,0x01,

/*
#####
..#..
..#..
..#..
..#..
..#..
..#..
.....
  T*/ 0x9f,0x10,0x42,0x08,0x01,

/*
#..#.
#..#.
#..#.
#..#.
#..#.
#..#.
.##..
.....
  U*/ 0x29,0xa5,0x94,0x92,0x01,

/*
#.#..
#.#..
#.#..
#.#..
#.#..
.#...
.#...
.....
  V*/ 0xa5,0x94,0x52,0x84,0x00,

/*
#.#.#
#.#.#
###.#
##.##
.#.#.
.#.#.
.#.#.
.....
  W*/ 0xb5,0xde,0xad,0x94,0x02,

/*
.#.#.
.#.#.
..#..
..#..
..#..
.#.#.
.#.#.
.....
  X*/ 0x4a,0x11,0x42,0x94,0x02,

/*
#.#..
#.#..
#.#..
.#...
.#...
.#...
.#...
.....
  Y*/ 0xa5,0x14,0x21,0x84,0x00,

/*
####.
...#.
..#..
.#...
.#...
#....
####.
.....
  Z*/ 0x0f,0x11,0x21,0xc2,0x03,

/*
###..
#....
#....
#....
#....
#....
#....
###..
  [*/ 0x27,0x84,0x10,0x42,0x38,

/*
#....
#....
.#...
.#...
..#..
...#.
.....
.....
  \*/ 0x21,0x08,0x41,0x10,0x00,

/*
###..
..#..
..#..
..#..
..#..
..#..
..#..
###..
  ]*/ 0x87,0x10,0x42,0x08,0x39,

/*
.#...
.##..
.##..
#..#.
.....
.....
.....
.....
  ^*/ 0xc2,0x98,0x04,0x00,0x00,

/*
####.
.....
.....
.....
.....
.....
.....
.....
  _*/ 0x0f,0x00,0x00,0x00,0x00,

/*
.#...
.....
.....
.....
.....
.....
.....
.....
  `*/ 0x02,0x00,0x00,0x00,0x00,

/*
.####
#...#
#...#
#...#
.####
.....
.....
.....
  a*/ 0x3e,0xc6,0xe8,0x01,0x00,

/*
#....
#....
####.
#...#
#...#
#...#
####.
.....
  b*/ 0x21,0xbc,0x18,0xe3,0x03,

/*
.###.
#....
#....
#....
.###.
.....
.....
.....
  c*/ 0x2e,0x84,0xe0,0x00,0x00,

/*
...#.
...#.
.###.
#..#.
#..#.
#..#.
.###.
.....
  d*/ 0x08,0xb9,0x94,0x92,0x03,

/*
.##..
#..#.
####.
#....
.###.
.....
.....
.....
  e*/ 0x26,0xbd,0xe0,0x00,0x00,

/*
..###
.#...
####.
.#...
.#...
.#...
.#...
.....
  f*/ 0x5c,0x3c,0x21,0x84,0x00,

/*
.###.
#..#.
#..#.
#..#.
.###.
...#.
###..
.....
  g*/ 0x2e,0xa5,0xe4,0xd0,0x01,

/*
#....
#....
###..
#..#.
#..#.
#..#.
#..#.
.....
  h*/ 0x21,0x9c,0x94,0x52,0x02,

/*
.#...
.....
##...
.#...
.#...
.#...
.##..
.....
  i*/ 0x02,0x0c,0x21,0x84,0x01,

/*
..#..
.....
###..
..#..
..#..
..#..
..#..
..#..
  j*/ 0x04,0x1c,0x42,0x08,0x21,

/*
#....
#....
#.#..
##...
##...
#.#..
#..#.
.....
  k*/ 0x21,0x94,0x31,0x4a,0x02,

/*
##...
.#...
.#...
.#...
.#...
.#...
.##..
.....
  l*/ 0x43,0x08,0x21,0x84,0x01,

/*
#####
#.#.#
#.#.#
#.#.#
#.#.#
.....
.....
.....
  m*/ 0xbf,0xd6,0x5a,0x01,0x00,

/*
###..
#..#.
#..#.
#..#.
#..#.
.....
.....
.....
  n*/ 0x27,0xa5,0x94,0x00,0x00,

/*
.##..
#..#.
#..#.
#..#.
.##..
.....
.....
.....
  o*/ 0x26,0xa5,0x64,0x00,0x00,

/*
####.
#...#
#...#
#...#
####.
#....
#....
.....
  p*/ 0x2f,0xc6,0xf8,0x42,0x00,

/*
.###.
#..#.
#..#.
#..#.
.###.
...#.
...#.
.....
  q*/ 0x2e,0xa5,0xe4,0x10,0x02,

/*
###..
#.#..
#....
#....
#....
.....
.....
.....
  r*/ 0xa7,0x84,0x10,0x00,0x00,

/*
.###.
#..#.
.###.
#..#.
###..
.....
.....
.....
  s*/ 0x2e,0xb9,0x74,0x00,0x00,

/*
.#...
.#...
####.
.#...
.#...
..##.
.....
.....
  t*/ 0x42,0x3c,0x21,0x18,0x00,

/*
#..#.
#..#.
#..#.
#..#.
.###.
.....
.....
.....
  u*/ 0x29,0xa5,0xe4,0x00,0x00,

/*
#.#..
#.#..
#.#..
###..
.#...
.....
.....
.....
  v*/ 0xa5,0x94,0x23,0x00,0x00,

/*
#.#.#
###.#
###.#
####.
.#.#.
.....
.....
.....
  w*/ 0xf5,0xde,0xa7,0x00,0x00,

/*
.#.#.
.##..
..#..
.#.#.
.#.#.
.....
.....
.....
  x*/ 0xca,0x10,0xa5,0x00,0x00,

/*
.#.#.
.#.#.
.#.#.
..##.
..#..
..#..
##...
.....
  y*/ 0x4a,0x29,0x46,0xc8,0x00,

/*
####.
..#..
.#...
#....
####.
.....
.....
.....
  z*/ 0x8f,0x88,0xf0,0x00,0x00,

/*
.##..
.#...
.#...
.#...
#....
.#...
.#...
.##..
  {*/ 0x46,0x08,0x11,0x84,0x30,

/*
#....
#....
#....
#....
#....
#....
.....
.....
  |*/ 0x21,0x84,0x10,0x02,0x00,

/*
##...
.#...
.#...
.#...
..#..
.#...
.#...
##...
  }*/ 0x43,0x08,0x41,0x84,0x18,

/*
#####
.....
.....
.....
.....
.....
.....
.....
  ~*/ 0x1f,0x00,0x00,0x00,0x00,

};

static uint8_t monaco_font_outline[127*MONACO_BYTES_PER_CHAR] = {};

static const int8_t monaco_height_adjust[] = {
   6,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,1,5,3,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,2,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6,0,1,-1,1,-1,1,-1,1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,-1,-1,-1,4,
};

#define RGB565(r, g, b) (((r) << 11) | ((g) << 5) | (b))

void DrawText(uint16_t *framebuffer, int framebufferWidth, int framebufferStrideBytes, int framebufferHeight, const char *text, int x, int y, uint16_t color, uint16_t bgColor);
