//////////////////////////////////////////////////////////////////////////////////	 
//ֻѧϰʹãδɣκ;
//ӲƬSTM32F103RCT6,ԭMiniSTM32,Ƶ72MHZ12MHZ
//QDtech-TFTҺ for STM32 IOģ
//xiao@ShenZhen QDtech co.,LTD
//˾վ:www.qdtft.com
//Ավhttp://qdtech.taobao.com
//wikiվhttp://www.lcdwiki.com
//˾ṩ֧֣κμ⻶ӭʱѧϰ
//̻() :+86 0755-23594567 
//ֻ:15989313508빤 
//:lcdwiki01@gmail.com    support@lcdwiki.com    goodtft@163.com 
//֧QQ:3002773612  3002778157
//QQȺ:324828016
//:2018/08/09
//汾V1.0
//ȨУؾ
//Copyright(C) ȫӼ޹˾ 2018-2028
//All rights reserved
/****************************************************************************************************
//ģֱӲԭMiniSTM32TFTLCDֶۣ
//STM32ָTFTLCDڲӵSTM32
//=========================================Դ================================================//
//     LCDģ             TFTLCD        STM32
//      VDD       --->         5V/3.3              DC5V/3.3V          //Դ
//      GND       --->          GND                  GND              //Դ
//=======================================Һ߽==========================================//
//ģĬΪ16λ
//     LCDģ             TFTLCD        STM32
//     D0~D15     --->         D0~D15               PB0~PB15          //Һ16λźţ8λģʽDB0~DB7D0~D7
//=======================================Һ߽==========================================//
//     LCDģ 			       TFTLCD        STM32 
//       WR       --->          WR                   PC7             //Һдݿź
//       RD       --->          RD                   PC6             //Һݿź
//       RS       --->          RS                   PC8             //Һ/ź
//       RST      --->          RST                  PC4             //Һλź
//       CS       --->          CS                   PC9             //ҺƬѡź
//       BL       --->          BL                   PC10            //Һź
//==================================================================================//
//ģ鲻ܻߴдܣǲҪܣҪд
//	   LCDģ             TFTLCD        STM32 
//      INI       --->          PEN                  PC1             //жź
//      SDA       --->          MOSI                 PC3             //IICź
//      CRST      --->          TCS                  PC13            //λź
//      CLK       --->          CLK                  PC0             //IICʱź
**************************************************************************************************/			
 /* @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, QD electronic SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
**************************************************************************************************/
#include "ctpiic.h"
#include "delay.h"	 

/*****************************************************************************
 * @name       :void CTP_Delay(void)
 * @date       :2020-05-13 
 * @function   :Delay in controlling IIC speed
 * @parameters :None
 * @retvalue   :None
******************************************************************************/
void CTP_Delay(void)
{
	delay_us(2);
} 

/*****************************************************************************
 * @name       :void CTP_IIC_Init(void)
 * @date       :2020-05-13 
 * @function   :Initialize IIC
 * @parameters :None
 * @retvalue   :None
******************************************************************************/
void CTP_IIC_Init(void)
{	
      GPIO_InitTypeDef GPIO_Initure;
    __HAL_RCC_GPIOH_CLK_ENABLE();			//GPIOHʱ
    
    GPIO_Initure.Pin=GPIO_PIN_4|GPIO_PIN_5;            //PH4,5
    GPIO_Initure.Mode=GPIO_MODE_OUTPUT_PP;  //
    GPIO_Initure.Pull=GPIO_PULLUP;          //
    GPIO_Initure.Speed=GPIO_SPEED_FAST;    //
    HAL_GPIO_Init(GPIOH,&GPIO_Initure);     //ʼ
}

/*****************************************************************************
 * @name       :void CTP_IIC_Start(void)
 * @date       :2020-05-13 
 * @function   :Generating IIC starting signal
 * @parameters :None
 * @retvalue   :None
******************************************************************************/
void CTP_IIC_Start(void)
{
	CTP_SDA_OUT();     //sda
	CTP_IIC_SDA(1);	  	  
	CTP_IIC_SCL(1);
	delay_us(30);
 	CTP_IIC_SDA(0);//START:when CLK is high,DATA change form high to low 
	CTP_Delay();
	CTP_IIC_SCL(0);//ǯסI2Cߣ׼ͻ 
}	

/*****************************************************************************
 * @name       :void CTP_IIC_Stop(void)
 * @date       :2020-05-13 
 * @function   :Generating IIC stop signal
 * @parameters :None
 * @retvalue   :None
******************************************************************************/   
void CTP_IIC_Stop(void)
{ 
	CTP_SDA_OUT();//sda
	CTP_IIC_SCL(0);
	CTP_IIC_SDA(0); //STOP:when CLK is high DATA change form low to high
	delay_us(30);
	CTP_IIC_SCL(1);
	CTP_Delay();
	CTP_IIC_SDA(1); //I2C߽ź 
}

/*****************************************************************************
 * @name       :u8 CTP_IIC_Wait_Ack(void)
 * @date       :2020-05-13 
 * @function   :Wait for the response signal
 * @parameters :None
 * @retvalue   :0-receive response signal successfully
								1-receive response signal unsuccessfully
******************************************************************************/ 
u8 CTP_IIC_Wait_Ack(void)
{
	u8 ucErrTime=0;
	CTP_SDA_IN();      //SDAΪ  
	CTP_IIC_SDA(1);	   
	CTP_IIC_SCL(1);	
	CTP_Delay();	
	while(CTP_READ_SDA)
	{
		ucErrTime++;
		if(ucErrTime>250)
		{
			CTP_IIC_Stop();
			return 1;
		} 
		CTP_Delay();
	}
	CTP_IIC_SCL(0);//ʱ0 	   
	return 0;  
} 

/*****************************************************************************
 * @name       :void CTP_IIC_Ack(void)
 * @date       :2020-05-13 
 * @function   :Generate ACK response signal
 * @parameters :None
 * @retvalue   :None
******************************************************************************/ 
void CTP_IIC_Ack(void)
{
	CTP_IIC_SCL(0);
	CTP_SDA_OUT();
	CTP_IIC_SDA(0);
	CTP_Delay();
	CTP_IIC_SCL(1);
	CTP_Delay();
	CTP_IIC_SCL(0);
}

/*****************************************************************************
 * @name       :void CTP_IIC_NAck(void)
 * @date       :2020-05-13 
 * @function   :Don't generate ACK response signal
 * @parameters :None
 * @retvalue   :None
******************************************************************************/	    
void CTP_IIC_NAck(void)
{
	CTP_IIC_SCL(0);
	CTP_SDA_OUT();
	CTP_IIC_SDA(1);
	CTP_Delay();
	CTP_IIC_SCL(1);
	CTP_Delay();
	CTP_IIC_SCL(0);
}	

/*****************************************************************************
 * @name       :void CTP_IIC_Send_Byte(u8 txd)
 * @date       :2020-05-13 
 * @function   :send a byte data by IIC bus
 * @parameters :txd:Data to be sent
 * @retvalue   :None
******************************************************************************/					 				     		  
void CTP_IIC_Send_Byte(u8 txd)
{                        
  u8 t;   
	CTP_SDA_OUT(); 	    
  CTP_IIC_SCL(0);//ʱӿʼݴ
  for(t=0;t<8;t++)
  {              
    CTP_IIC_SDA((txd&0x80)>>7);
    txd<<=1; 	
		CTP_Delay();		
		CTP_IIC_SCL(1);
		CTP_Delay();
		CTP_IIC_SCL(0);	
		CTP_Delay();
  }	 
} 	

/*****************************************************************************
 * @name       :u8 CTP_IIC_Read_Byte(unsigned char ack)
 * @date       :2020-05-13 
 * @function   :read a byte data by IIC bus
 * @parameters :ack:0-send nACK
									  1-send ACK
 * @retvalue   :Data to be read
******************************************************************************/	    
u8 CTP_IIC_Read_Byte(unsigned char ack)
{
	u8 i,receive=0;
 	CTP_SDA_IN();//SDAΪ
	delay_us(30);
  for(i=0;i<8;i++ )
	{
    CTP_IIC_SCL(0); 	    	   
		CTP_Delay();
		CTP_IIC_SCL(1);  
		receive<<=1;
		if(CTP_READ_SDA)receive++;
		CTP_Delay();			
	}	  				 
	if (!ack)CTP_IIC_NAck();//nACK
	else CTP_IIC_Ack(); //ACK   
 	return receive;
}




























