#include "mpu.h"
#include "led.h"
#include "delay.h"

//ĳMPU
//baseaddr:MPUĻַ(׵ַ)
//size:MPUĴС(32ı,λΪֽ),õֵο:CORTEX_MPU_Region_Size
//rnum:MPU,Χ:0~7,֧8,õֵοCORTEX_MPU_Region_Number
//ap:Ȩ,ʹϵ:õֵοCORTEX_MPU_Region_Permission_Attributes
//MPU_REGION_NO_ACCESS,޷ʣȨ&ûɷʣ
//MPU_REGION_PRIV_RW,֧Ȩд
//MPU_REGION_PRIV_RW_URO,ֹûдʣȨɶдʣ
//MPU_REGION_FULL_ACCESS,ȫʣȨ&ûɷʣ
//MPU_REGION_PRIV_RO,֧Ȩ
//MPU_REGION_PRIV_RO_URO,ֻȨ&ûд
//:STM32F7ֲ.pdf,4.6,Table 89.
//sen:Ƿ;MPU_ACCESS_NOT_SHAREABLE,;MPU_ACCESS_SHAREABLE,
//cen:Ƿcache;MPU_ACCESS_NOT_CACHEABLE,;MPU_ACCESS_CACHEABLE,
//ben:Ƿ;MPU_ACCESS_NOT_BUFFERABLE,;MPU_ACCESS_BUFFERABLE,
//ֵ;0,ɹ.
//    ,.
u8 MPU_Set_Protection(u32 baseaddr,u32 size,u32 rnum,u8 ap,u8 sen,u8 cen,u8 ben)
{
	MPU_Region_InitTypeDef MPU_Initure;
	
	HAL_MPU_Disable();								        //MPU֮ǰȹرMPU,ԺʹMPU

	MPU_Initure.Enable=MPU_REGION_ENABLE;			        //ʹܸñ 
	MPU_Initure.Number=rnum;			                    //ñ
	MPU_Initure.BaseAddress=baseaddr;	                    //ûַ
	MPU_Initure.Size=size;				                    //ñС
	MPU_Initure.SubRegionDisable=0X00;                      //ֹ
	MPU_Initure.TypeExtField=MPU_TEX_LEVEL0;                //չΪlevel0
	MPU_Initure.AccessPermission=(u8)ap;		            //÷Ȩ,
	MPU_Initure.DisableExec=MPU_INSTRUCTION_ACCESS_ENABLE;	//ָ(ȡָ)
	MPU_Initure.IsShareable=sen;                            //Ƿ?
    MPU_Initure.IsCacheable=cen;                            //Ƿcache?     
	MPU_Initure.IsBufferable=ben;                           //Ƿ񻺳?
	HAL_MPU_ConfigRegion(&MPU_Initure);                     //MPU
	HAL_MPU_Enable(MPU_PRIVILEGED_DEFAULT);			        //MPU
    return 0;
}

//ҪĴ洢
//Բִ洢MPU,ܵ³쳣
//MCUʾ,ͷɼݳȵ...
void MPU_Memory_Protection(void)
{
    //D1 SRAM 512KB
    MPU_Set_Protection( 0x24000000,                 //ַ
                        MPU_REGION_SIZE_512KB,      //
                        MPU_REGION_NUMBER1,         //NUMER1
                        MPU_REGION_FULL_ACCESS,     //ȫ
                        MPU_ACCESS_SHAREABLE,       //
                        MPU_ACCESS_CACHEABLE,       //cache
                        MPU_ACCESS_NOT_BUFFERABLE); //ֹ
    
    //SDRAM,32Mֽ  
    MPU_Set_Protection( 0XC0000000,                 //ַ
                        MPU_REGION_SIZE_32MB,       //
                        MPU_REGION_NUMBER2,         //NUMER2
                        MPU_REGION_FULL_ACCESS,     //ȫ
                        MPU_ACCESS_NOT_SHAREABLE,   //ֹ
                        MPU_ACCESS_CACHEABLE,       //cache
                        MPU_ACCESS_BUFFERABLE);     //
}


