#include "sys.h"  

//********************************************************************************
//޸˵
//
////////////////////////////////////////////////////////////////////////////////// 

//ʹCPUL1-Cache
void Cache_Enable(void)
{
    SCB_EnableICache();//ʹI-Cache
    SCB_EnableDCache();//ʹD-Cache   
		SCB->CACR|=1<<2;   //ǿD-Cache͸д,粻,ʵʹп
}
//ʱú
//Fvco=Fs*(plln/pllm);
//Fsys=Fvco/pllp=Fs*(plln/(pllm*pllp));
//Fusb=Fvco/pllq=Fs*(plln/(pllm*pllq));

//Fvco:VCOƵ
//Fsys:ϵͳʱƵ
//Fusb:USB,SDIO,RNGȵʱƵ
//Fs:PLLʱƵ,HSI,HSE. 
//plln:PLLƵϵ(PLLƵ),ȡֵΧ:64~432.
//pllm:PLLƵPLLƵϵ(PLL֮ǰķƵ),ȡֵΧ:2~63.
//pllp:ϵͳʱӵPLLƵϵ(PLL֮ķƵ),ȡֵΧ:2,4,6,8.(4ֵ!)
//pllq:USB/SDIO/ȵPLLƵϵ(PLL֮ķƵ),ȡֵΧ:2~15.

//ⲿΪ25Mʱ,Ƽֵ:plln=432,pllm=25,pllp=2,pllq=9.
//õ:Fvco=25*(432/25)=432Mhz
//     Fsys=432/2=216Mhz
//     Fusb=432/9=48Mhz
//ֵ:0,ɹ;1,ʧ
void Stm32_Clock_Init(u32 plln,u32 pllm,u32 pllp,u32 pllq)
{
    HAL_StatusTypeDef ret = HAL_OK;
    RCC_OscInitTypeDef RCC_OscInitStructure; 
    RCC_ClkInitTypeDef RCC_ClkInitStructure;
	
    __HAL_RCC_PWR_CLK_ENABLE(); //ʹPWRʱ
 
    __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);//õѹѹԱδƵʹ
      
    RCC_OscInitStructure.OscillatorType=RCC_OSCILLATORTYPE_HSE;    //ʱԴΪHSE
    RCC_OscInitStructure.HSEState=RCC_HSE_ON;                      //HSE
    RCC_OscInitStructure.PLL.PLLState=RCC_PLL_ON;				   //PLL
    RCC_OscInitStructure.PLL.PLLSource=RCC_PLLSOURCE_HSE;          //PLLʱԴѡHSE
    RCC_OscInitStructure.PLL.PLLM=pllm;	//PLLƵPLLƵϵ(PLL֮ǰķƵ)
    RCC_OscInitStructure.PLL.PLLN=plln; //PLLƵϵ(PLLƵ)
    RCC_OscInitStructure.PLL.PLLP=pllp; //ϵͳʱӵPLLƵϵ(PLL֮ķƵ)
    RCC_OscInitStructure.PLL.PLLQ=pllq; //USB/SDIO/ȵPLLƵϵ(PLL֮ķƵ)
    ret=HAL_RCC_OscConfig(&RCC_OscInitStructure);//ʼ
    if(ret!=HAL_OK) while(1);
    
    ret=HAL_PWREx_EnableOverDrive(); //Over-Driver
    if(ret!=HAL_OK) while(1);
    
    //ѡPLLΪϵͳʱԴHCLK,PCLK1PCLK2
    RCC_ClkInitStructure.ClockType=(RCC_CLOCKTYPE_SYSCLK|RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2);
    RCC_ClkInitStructure.SYSCLKSource=RCC_SYSCLKSOURCE_PLLCLK;//ϵͳʱʱԴΪPLL
    RCC_ClkInitStructure.AHBCLKDivider=RCC_SYSCLK_DIV1;//AHBƵϵΪ1
    RCC_ClkInitStructure.APB1CLKDivider=RCC_HCLK_DIV4;//APB1ƵϵΪ4
    RCC_ClkInitStructure.APB2CLKDivider=RCC_HCLK_DIV2;//APB2ƵϵΪ2
    
    ret=HAL_RCC_ClockConfig(&RCC_ClkInitStructure,FLASH_LATENCY_7);//ͬʱFLASHʱΪ7WSҲ8CPUڡ
    if(ret!=HAL_OK) while(1);
}


#ifdef  USE_FULL_ASSERT
//ʾʱ˺ļ
//fileָԴļ
//lineָļе
void assert_failed(uint8_t* file, uint32_t line)
{ 
	while (1)
	{
	}
}
#endif

//жI_CacheǷ
//ֵ:0 رգ1 
u8 Get_ICahceSta(void)
{
    u8 sta;
    sta=((SCB->CCR)>>17)&0X01;
    return sta;
}

//жI_DacheǷ
//ֵ:0 رգ1 
u8 Get_DCahceSta(void)
{
    u8 sta;
    sta=((SCB->CCR)>>16)&0X01;
    return sta;
}

//THUMBָֻ֧
//·ʵִлָWFI  
__asm void WFI_SET(void)
{
	WFI;		  
}
//رж(ǲfaultNMIж)
__asm void INTX_DISABLE(void)
{
	CPSID   I
	BX      LR	  
}
//ж
__asm void INTX_ENABLE(void)
{
	CPSIE   I
	BX      LR  
}
//ջַ
//addr:ջַ
__asm void MSR_MSP(u32 addr) 
{
	MSR MSP, r0 			//set Main Stack value
	BX r14
}
