#include "sdram.h"
#include "delay.h"

SDRAM_HandleTypeDef SDRAM_Handler;   //SDRAM

//SDRAMʼ
void SDRAM_Init(void)
{

    FMC_SDRAM_TimingTypeDef SDRAM_Timing;
                                                     
    SDRAM_Handler.Instance=FMC_SDRAM_DEVICE;                             //SDRAMBANK5,6  
    SDRAM_Handler.Init.SDBank=FMC_SDRAM_BANK1;                           //SDRAMBANK5
    SDRAM_Handler.Init.ColumnBitsNumber=FMC_SDRAM_COLUMN_BITS_NUM_9;     //
    SDRAM_Handler.Init.RowBitsNumber=FMC_SDRAM_ROW_BITS_NUM_13;          //
    SDRAM_Handler.Init.MemoryDataWidth=FMC_SDRAM_MEM_BUS_WIDTH_16;       //ݿΪ16λ
    SDRAM_Handler.Init.InternalBankNumber=FMC_SDRAM_INTERN_BANKS_NUM_4;  //һ4BANK
    SDRAM_Handler.Init.CASLatency=FMC_SDRAM_CAS_LATENCY_3;               //CASΪ3
    SDRAM_Handler.Init.WriteProtection=FMC_SDRAM_WRITE_PROTECTION_DISABLE;//ʧд
    SDRAM_Handler.Init.SDClockPeriod=FMC_SDRAM_CLOCK_PERIOD_2;           //SDRAMʱΪHCLK/2=180M/2=90M=11.1ns
    SDRAM_Handler.Init.ReadBurst=FMC_SDRAM_RBURST_ENABLE;                //ʹͻ
    SDRAM_Handler.Init.ReadPipeDelay=FMC_SDRAM_RPIPE_DELAY_1;            //ͨʱ
    
    SDRAM_Timing.LoadToActiveDelay=2;                                   //ģʽĴʱӳΪ2ʱ
    SDRAM_Timing.ExitSelfRefreshDelay=8;                                //˳ˢӳΪ8ʱ
    SDRAM_Timing.SelfRefreshTime=6;                                     //ˢʱΪ6ʱ                                 
    SDRAM_Timing.RowCycleDelay=6;                                       //ѭӳΪ6ʱ
    SDRAM_Timing.WriteRecoveryTime=2;                                   //ָӳΪ2ʱ
    SDRAM_Timing.RPDelay=2;                                             //ԤӳΪ2ʱ
    SDRAM_Timing.RCDDelay=2;                                            //еӳΪ2ʱ
    HAL_SDRAM_Init(&SDRAM_Handler,&SDRAM_Timing);
		
    SDRAM_Initialization_Sequence(&SDRAM_Handler);//SDRAMʼ

}
//SDRAMʼ
void SDRAM_Initialization_Sequence(SDRAM_HandleTypeDef *hsdram)
{
    u32 temp=0;
    //SDRAMʼԺҪ˳ʼSDRAM
    SDRAM_Send_Cmd(0,FMC_SDRAM_CMD_CLK_ENABLE,1,0); //ʱʹ
    delay_us(500);                                  //ʱ200us
    SDRAM_Send_Cmd(0,FMC_SDRAM_CMD_PALL,1,0);       //д洢Ԥ
    SDRAM_Send_Cmd(0,FMC_SDRAM_CMD_AUTOREFRESH_MODE,8,0);//ˢ´ 
    //ģʽĴ,SDRAMbit0~bit2Ϊָͻʵĳȣ
	  //bit3Ϊָͻʵͣbit4~bit6ΪCASֵbit7bit8Ϊģʽ
	  //bit9Ϊָдͻģʽbit10bit11λλ
	  temp=(u32)SDRAM_MODEREG_BURST_LENGTH_1          |	//ͻ:1(1/2/4/8)
              SDRAM_MODEREG_BURST_TYPE_SEQUENTIAL   |	//ͻ:(/)
              SDRAM_MODEREG_CAS_LATENCY_3           |	//CASֵ:3(2/3)
              SDRAM_MODEREG_OPERATING_MODE_STANDARD |   //òģʽ:0,׼ģʽ
              SDRAM_MODEREG_WRITEBURST_MODE_SINGLE;     //ͻдģʽ:1,
    SDRAM_Send_Cmd(0,FMC_SDRAM_CMD_LOAD_MODE,1,temp);   //SDRAMģʽĴ
    
    //ˢƵʼ(SDCLKƵʼ),㷽:
	  //COUNT=SDRAMˢ/-20=SDRAMˢ(us)*SDCLKƵ(Mhz)/
    //ʹõSDRAMˢΪ64ms,SDCLK=180/2=90Mhz,Ϊ8192(2^13).
	  //,COUNT=64*1000*90/8192-20=683
	HAL_SDRAM_ProgramRefreshRate(&SDRAM_Handler,683);

}
//SDRAMײãʱʹ
//˺ᱻHAL_SDRAM_Init()
//hsdram:SDRAM
void HAL_SDRAM_MspInit(SDRAM_HandleTypeDef *hsdram)
{
    GPIO_InitTypeDef GPIO_Initure;
    
    __HAL_RCC_FMC_CLK_ENABLE();                 //ʹFMCʱ
    __HAL_RCC_GPIOC_CLK_ENABLE();               //ʹGPIOCʱ
    __HAL_RCC_GPIOD_CLK_ENABLE();               //ʹGPIODʱ
    __HAL_RCC_GPIOE_CLK_ENABLE();               //ʹGPIOEʱ
    __HAL_RCC_GPIOF_CLK_ENABLE();               //ʹGPIOFʱ
    __HAL_RCC_GPIOG_CLK_ENABLE();               //ʹGPIOGʱ
    
    GPIO_Initure.Pin=GPIO_PIN_0|GPIO_PIN_2|GPIO_PIN_3;  
    GPIO_Initure.Mode=GPIO_MODE_AF_PP;          //츴
    GPIO_Initure.Pull=GPIO_PULLUP;              //
    GPIO_Initure.Speed=GPIO_SPEED_HIGH;         //
    GPIO_Initure.Alternate=GPIO_AF12_FMC;       //ΪFMC    
    HAL_GPIO_Init(GPIOC,&GPIO_Initure);          //ʼPC0,2,3
    
    GPIO_Initure.Pin=GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_8|GPIO_PIN_9|GPIO_PIN_10|GPIO_PIN_14|GPIO_PIN_15;              
    HAL_GPIO_Init(GPIOD,&GPIO_Initure);     //ʼPD0,1,8,9,10,14,15
    
    GPIO_Initure.Pin=GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_7|GPIO_PIN_8|GPIO_PIN_9|GPIO_PIN_10| GPIO_PIN_11|GPIO_PIN_12|GPIO_PIN_13|GPIO_PIN_14|GPIO_PIN_15;              
    HAL_GPIO_Init(GPIOE,&GPIO_Initure);     //ʼPE0,1,7,8,9,10,11,12,13,14,15
    
    GPIO_Initure.Pin=GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_11|GPIO_PIN_12|GPIO_PIN_13|GPIO_PIN_14|GPIO_PIN_15;              
    HAL_GPIO_Init(GPIOF,&GPIO_Initure);     //ʼPF0,1,2,3,4,5,11,12,13,14,15
    
    GPIO_Initure.Pin=GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_8|GPIO_PIN_15;              
    HAL_GPIO_Init(GPIOG,&GPIO_Initure);      //ʼPG0,1,2,4,5,8,15 
}

//SDRAM
//bankx:0,BANK5SDRAMָ
//      1,BANK6SDRAMָ
//cmd:ָ(0,ģʽ/1,ʱʹ/2,Ԥд洢/3,Զˢ/4,ģʽĴ/5,ˢ/6,)
//refresh:ˢ´
//regval:ģʽĴĶ
//ֵ:0,;1,ʧ.
u8 SDRAM_Send_Cmd(u8 bankx,u8 cmd,u8 refresh,u16 regval)
{
    u32 target_bank=0;
    FMC_SDRAM_CommandTypeDef Command;
    
    if(bankx==0) target_bank=FMC_SDRAM_CMD_TARGET_BANK1;       
    else if(bankx==1) target_bank=FMC_SDRAM_CMD_TARGET_BANK2;   
    Command.CommandMode=cmd;                //
    Command.CommandTarget=target_bank;      //ĿSDRAM洢
    Command.AutoRefreshNumber=refresh;      //ˢ´
    Command.ModeRegisterDefinition=regval;  //ҪдģʽĴֵ
    if(HAL_SDRAM_SendCommand(&SDRAM_Handler,&Command,0X1000)==HAL_OK) //SDRAM
    {
        return 0;  
    }
    else return 1;    
}

//ַָ(WriteAddr+Bank5_SDRAM_ADDR)ʼ,дnֽ.
//pBuffer:ָֽ
//WriteAddr:Ҫдĵַ
//n:Ҫдֽ
void FMC_SDRAM_WriteBuffer(u8 *pBuffer,u32 WriteAddr,u32 n)
{
	for(;n!=0;n--)
	{
		*(vu8*)(Bank5_SDRAM_ADDR+WriteAddr)=*pBuffer;
		WriteAddr++;
		pBuffer++;
	}
}

//ַָ((WriteAddr+Bank5_SDRAM_ADDR))ʼ,nֽ.
//pBuffer:ָֽ
//ReadAddr:Ҫʼַ
//n:Ҫдֽ
void FMC_SDRAM_ReadBuffer(u8 *pBuffer,u32 ReadAddr,u32 n)
{
	for(;n!=0;n--)
	{
		*pBuffer++=*(vu8*)(Bank5_SDRAM_ADDR+ReadAddr);
		ReadAddr++;
	}
}
