#include "lcd.h"
#include "stdlib.h"
#include "usart.h"
#include "delay.h"	 
//////////////////////////////////////////////////////////////////////////////////	 
//ֻѧϰʹãδɣκ;
//ӲƬSTM32F103RCT6,ԭMiniSTM32,Ƶ72MHZ
//QDtech-TFTҺ for STM32
//xiao@ShenZhen QDtech co.,LTD
//˾վ:www.qdtft.com
//Ավhttp://qdtech.taobao.com
//wikiվhttp://www.lcdwiki.com
//˾ṩ֧֣κμ⻶ӭʱѧϰ
//̻() :+86 0755-23594567 
//ֻ:15989313508빤 
//:lcdwiki01@gmail.com    support@lcdwiki.com    goodtft@163.com
//֧QQ:3002773612  3002778157
//QQȺ:324828016
//:2018/7/7
//汾V1.0
//ȨУؾ
//Copyright(C) ȫӼ޹˾ 2018-2028
//All rights reserved
//********************************************************************************
//=========================================Դ================================================//
//5VDC 5VԴ
//GNDӵ
//=======================================Һ߽==========================================//
//ģĬΪSPI
//Һģ             Ƭ
// SDI(MOSI)            PB15        //SPIдź
// SDO(MISO)            PB14        //SPI߶źţҪܣ˹ܽſɲ
//=======================================Һ߽==========================================//
//Һģ             Ƭ
//  CS                  PB11        //Ƭѡź
//  RESET               PB12        //λź
//  DC                  PB10        ///Ĵѡź
//  SCK                 PB13        //SPIʱź
//  LED                 PB9         //źţҪƣ3.3V
//==================================================================================//
//ʹôģ鱾ɲ
//ʹõΪSPI
//ģ             Ƭ
//  T_CLK               PC0         //SPIʱź
//  T_CS                PC13        //Ƭѡź
//  T_DIN               PC3         //SPIдź
//  T_DO                PC2         //SPI߶ź
//  T_IRQ               PC1         //жź
//**************************************************************************************************/	
	   
//LCDҪ
//ĬΪ
_lcd_dev lcddev;

//ɫ,ɫ
u16 POINT_COLOR = 0x0000,BACK_COLOR = 0xFFFF;  
u16 DeviceCode;	 

/****************************************************************************
*     ƣu8 SPI_WriteByte(SPI_TypeDef* SPIx,u8 Byte)
*     ܣSTM32_ӲSPIдһֽݵײ㺯
* ڲSPIx,Byte
* ڲյ
* ˵    STM32_ӲSPIдһֽݵײ㺯
****************************************************************************/
u8 SPI_WriteByte(SPI_TypeDef* SPIx,u8 Byte)
{
	while((SPIx->SR&SPI_I2S_FLAG_TXE)==RESET);		//ȴ	  
	SPIx->DR=Byte;	 	//һbyte   
	while((SPIx->SR&SPI_I2S_FLAG_RXNE)==RESET);//ȴһbyte  
	return SPIx->DR;          	     //յ			
} 

/****************************************************************************
*     ƣvoid SPI_SetSpeed(SPI_TypeDef* SPIx,u8 SpeedSet)
*     ܣSPIٶ
* ڲSPIx,SpeedSet
* ڲ
* ˵    SpeedSet:1,;0,;
****************************************************************************/
void SPI_SetSpeed(SPI_TypeDef* SPIx,u8 SpeedSet)
{
	SPIx->CR1&=0XFFC7;
	if(SpeedSet==1)//
	{
		SPIx->CR1|=SPI_BaudRatePrescaler_2;//Fsck=Fpclk/2	
	}
	else//
	{
		SPIx->CR1|=SPI_BaudRatePrescaler_32; //Fsck=Fpclk/32
	}
	SPIx->CR1|=1<<6; //SPI豸ʹ
} 

/****************************************************************************
*     ƣSPI2_Init(void)
*     ܣSTM32_SPI2Ӳóʼ
* ڲ
* ڲ
* ˵    STM32_SPI2Ӳóʼ
****************************************************************************/
void SPI2_Init(void)	
{
	SPI_InitTypeDef  SPI_InitStructure;
	GPIO_InitTypeDef GPIO_InitStructure;
	 
	//SPI2ܽ
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO|RCC_APB2Periph_GPIOB, ENABLE);
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_13 | GPIO_Pin_15;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
	GPIO_Init(GPIOB, &GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Pin =  GPIO_Pin_14;    
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU; 
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;  
	GPIO_Init(GPIOB, &GPIO_InitStructure);  

	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_9|GPIO_Pin_10| GPIO_Pin_11| GPIO_Pin_12;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
	GPIO_Init(GPIOB, &GPIO_InitStructure);
	
	//SPI2ѡ
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_SPI2 ,ENABLE);
	   
	SPI_InitStructure.SPI_Direction = SPI_Direction_2Lines_FullDuplex;
	SPI_InitStructure.SPI_Mode = SPI_Mode_Master;
	SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;
	SPI_InitStructure.SPI_CPOL = SPI_CPOL_High;
	SPI_InitStructure.SPI_CPHA = SPI_CPHA_2Edge;
	SPI_InitStructure.SPI_NSS = SPI_NSS_Soft;
	SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_2;
	SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;
	SPI_InitStructure.SPI_CRCPolynomial = 7;
	SPI_Init(SPI2, &SPI_InitStructure);

	//ʹSPI2
	SPI_Cmd(SPI2, ENABLE);   
}


//******************************************************************
//  LCD_WR_REG
//ߣ    xiao@ȫ
//ڣ    2013-02-22
//ܣ    Һдд16λָ
//Reg:дֵָ
//ֵ  
//޸ļ¼
//******************************************************************
void LCD_WR_REG(u8 data)
{ 
   LCD_CS_CLR;
   LCD_RS_CLR;  
   SPI_WriteByte(SPI2,data);
   LCD_CS_SET;
}

//******************************************************************
//  LCD_WR_DATA
//ߣ    xiao@ȫ
//ڣ    2013-02-22
//ܣ    Һдһ8λ
//Data:д
//ֵ  
//޸ļ¼
//******************************************************************
void LCD_WR_DATA(u8 data)
{	
   LCD_CS_CLR;
   LCD_RS_SET;  
   SPI_WriteByte(SPI2,data);
   LCD_CS_SET;
}
//******************************************************************
//  LCD_DrawPoint_16Bit
//ߣ    xiao@ȫ
//ڣ    2013-02-22
//ܣ    8λдһ16λ
//(x,y):
//ֵ  
//޸ļ¼
//******************************************************************
void LCD_DrawPoint_16Bit(u16 color)
{
   LCD_CS_CLR;
   LCD_RS_SET;  
   SPI_WriteByte(SPI2,color>>8);
	 SPI_WriteByte(SPI2,color);
   LCD_CS_SET;

}
//******************************************************************
//  LCD_DrawPoint
//ߣ    xiao@ȫ
//ڣ    2013-02-22
//ܣ    ָλдһص
//(x,y):
//ֵ  
//޸ļ¼
//******************************************************************
void LCD_DrawPoint(u16 x,u16 y)
{
	LCD_SetCursor(x,y);//ùλ 
   LCD_CS_CLR;
   LCD_RS_SET;  
   SPI_WriteByte(SPI2,POINT_COLOR>>8);
	 SPI_WriteByte(SPI2,POINT_COLOR);
   LCD_CS_SET;
}

//******************************************************************
//  LCD_WriteReg
//ߣ    xiao@ȫ
//ڣ    2013-02-22
//ܣ    дĴ
//LCD_Reg:Ĵַ
//			LCD_RegValue:Ҫд
//ֵ  
//޸ļ¼
//******************************************************************
void LCD_WriteReg(u8 LCD_Reg, u16 LCD_RegValue)
{	
	LCD_WR_REG(LCD_Reg);  
	LCD_WR_DATA(LCD_RegValue);	    		 
}	   
	 
//******************************************************************
//  LCD_WriteRAM_Prepare
//ߣ    xiao@ȫ
//ڣ    2013-02-22
//ܣ    ʼдGRAM
//			ڸҺRGBǰӦ÷дGRAMָ
//
//ֵ  
//޸ļ¼
//******************************************************************
void LCD_WriteRAM_Prepare(void)
{
	LCD_WR_REG(lcddev.wramcmd);
}	 

//******************************************************************
//  LCD_Reset
//ߣ    xiao@ȫ
//ڣ    2013-02-22
//ܣ    LCDλҺʼǰҪô˺
//
//ֵ  
//޸ļ¼
//******************************************************************
void LCD_RESET(void)
{
	LCD_RST_CLR;
	delay_ms(100);	
	LCD_RST_SET;
	delay_ms(50);
}
 	 
//******************************************************************
//  LCD_Init
//ߣ    xiao@ȫ
//ڣ    2013-02-22
//ܣ    LCDʼ
//
//ֵ  
//޸ļ¼
//******************************************************************
void LCD_Init(void)
{     										 
	SPI2_Init(); //ʼӲSPI
	LCD_RESET(); //Reset before LCD Init.
	

	//************* Start Initial Sequence **********//		
	LCD_WR_REG(0xCF);  
	LCD_WR_DATA(0x00); 
	LCD_WR_DATA(0xC1); 
	LCD_WR_DATA(0X30); 
	LCD_WR_REG(0xED);  
	LCD_WR_DATA(0x64); 
	LCD_WR_DATA(0x03); 
	LCD_WR_DATA(0X12); 
	LCD_WR_DATA(0X81); 
	LCD_WR_REG(0xE8);  
	LCD_WR_DATA(0x85); 
	LCD_WR_DATA(0x10); 
	LCD_WR_DATA(0x7A); 
	LCD_WR_REG(0xCB);  
	LCD_WR_DATA(0x39); 
	LCD_WR_DATA(0x2C); 
	LCD_WR_DATA(0x00); 
	LCD_WR_DATA(0x34); 
	LCD_WR_DATA(0x02); 
	LCD_WR_REG(0xF7);  
	LCD_WR_DATA(0x20); 
	LCD_WR_REG(0xEA);  
	LCD_WR_DATA(0x00); 
	LCD_WR_DATA(0x00); 
	LCD_WR_REG(0xC0);    //Power control 
	LCD_WR_DATA(0x1B);   //VRH[5:0] 
	LCD_WR_REG(0xC1);    //Power control 
	LCD_WR_DATA(0x01);   //SAP[2:0];BT[3:0] 
	LCD_WR_REG(0xC5);    //VCM control 
	LCD_WR_DATA(0x30); 	 //3F
	LCD_WR_DATA(0x30); 	 //3C
	LCD_WR_REG(0xC7);    //VCM control2 
	LCD_WR_DATA(0XB7); 
	LCD_WR_REG(0x36);    // Memory Access Control 
	LCD_WR_DATA(0x48); 
	LCD_WR_REG(0x3A);   
	LCD_WR_DATA(0x55); 
	LCD_WR_REG(0xB1);   
	LCD_WR_DATA(0x00);   
	LCD_WR_DATA(0x1A); 
	LCD_WR_REG(0xB6);    // Display Function Control 
	LCD_WR_DATA(0x0A); 
	LCD_WR_DATA(0xA2); 
	LCD_WR_REG(0xF2);    // 3Gamma Function Disable 
	LCD_WR_DATA(0x00); 
	LCD_WR_REG(0x26);    //Gamma curve selected 
	LCD_WR_DATA(0x01); 
	LCD_WR_REG(0xE0);    //Set Gamma 
	LCD_WR_DATA(0x0F); 
	LCD_WR_DATA(0x2A); 
	LCD_WR_DATA(0x28); 
	LCD_WR_DATA(0x08); 
	LCD_WR_DATA(0x0E); 
	LCD_WR_DATA(0x08); 
	LCD_WR_DATA(0x54); 
	LCD_WR_DATA(0XA9); 
	LCD_WR_DATA(0x43); 
	LCD_WR_DATA(0x0A); 
	LCD_WR_DATA(0x0F); 
	LCD_WR_DATA(0x00); 
	LCD_WR_DATA(0x00); 
	LCD_WR_DATA(0x00); 
	LCD_WR_DATA(0x00); 		 
	LCD_WR_REG(0XE1);    //Set Gamma 
	LCD_WR_DATA(0x00); 
	LCD_WR_DATA(0x15); 
	LCD_WR_DATA(0x17); 
	LCD_WR_DATA(0x07); 
	LCD_WR_DATA(0x11); 
	LCD_WR_DATA(0x06); 
	LCD_WR_DATA(0x2B); 
	LCD_WR_DATA(0x56); 
	LCD_WR_DATA(0x3C); 
	LCD_WR_DATA(0x05); 
	LCD_WR_DATA(0x10); 
	LCD_WR_DATA(0x0F); 
	LCD_WR_DATA(0x3F); 
	LCD_WR_DATA(0x3F); 
	LCD_WR_DATA(0x0F); 
	LCD_WR_REG(0x2B); 
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x01);
	LCD_WR_DATA(0x3f);
	LCD_WR_REG(0x2A); 
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0xef);	 
	LCD_WR_REG(0x11); //Exit Sleep
	delay_ms(120);
	LCD_WR_REG(0x29); //display on	


	LCD_SetParam();//LCD	 
	LCD_BL_SET;//ߵƽҺ
}
//******************************************************************
//  LCD_Clear
//ߣ    xiao@ȫ
//ڣ    2013-02-22
//ܣ    LCDȫ
//Color:Ҫɫ
//ֵ  
//޸ļ¼
//******************************************************************
void LCD_Clear(u16 Color)
{
	u32 index=0;      
	LCD_SetWindows(0,0,lcddev.width-1,lcddev.height-1);	
	LCD_CS_CLR;	
	LCD_RS_SET;//д    
	for(index=0;index<lcddev.width*lcddev.height;index++)
	{  
   SPI_WriteByte(SPI2,Color>>8);
	 SPI_WriteByte(SPI2,Color);  
	}
	LCD_CS_SET;	
		
}   		  
/*************************************************
LCD_SetWindows
ܣlcdʾڣڴдԶ
ڲxyյ
ֵ
*************************************************/
void LCD_SetWindows(u16 xStar, u16 yStar,u16 xEnd,u16 yEnd)
{	
	LCD_WR_REG(lcddev.setxcmd);	
	LCD_WR_DATA(xStar>>8);
	LCD_WR_DATA(0x00FF&xStar);		
	LCD_WR_DATA(xEnd>>8);
	LCD_WR_DATA(0x00FF&xEnd);

	LCD_WR_REG(lcddev.setycmd);	
	LCD_WR_DATA(yStar>>8);
	LCD_WR_DATA(0x00FF&yStar);		
	LCD_WR_DATA(yEnd>>8);
	LCD_WR_DATA(0x00FF&yEnd);	

	LCD_WriteRAM_Prepare();	//ʼдGRAM				
}   

/*************************************************
LCD_SetCursor
ܣùλ
ڲxy
ֵ
*************************************************/
void LCD_SetCursor(u16 Xpos, u16 Ypos)
{	  	    			
	LCD_WR_REG(lcddev.setxcmd);	
	LCD_WR_DATA(Xpos>>8);
	LCD_WR_DATA(0x00FF&Xpos);		

	
	LCD_WR_REG(lcddev.setycmd);	
	LCD_WR_DATA(Ypos>>8);
	LCD_WR_DATA(0x00FF&Ypos);		

	LCD_WriteRAM_Prepare();	//ʼдGRAM	
} 

//LCD
//кģʽл
void LCD_SetParam(void)
{ 	
	lcddev.wramcmd=0x2C;
#if USE_HORIZONTAL==1	//ʹú	  
	lcddev.dir=1;//
	lcddev.width=320;
	lcddev.height=240;
	lcddev.setxcmd=0x2A;
	lcddev.setycmd=0x2B;			
	LCD_WriteReg(0x36,0x6C);

#else//
	lcddev.dir=0;//				 	 		
	lcddev.width=240;
	lcddev.height=320;
	lcddev.setxcmd=0x2A;
	lcddev.setycmd=0x2B;	
	LCD_WriteReg(0x36,0x0A);
#endif
}	


