//////////////////////////////////////////////////////////////////////////////////	 
//ֻѧϰʹãδɣκ;
//ӲƬSTM32F429IGT6,ԭApollo STM32F4/F7,Ƶ180MHZ12MHZ
//QDtech-TFTҺ for STM32 IOģ
//xiao@ShenZhen QDtech co.,LTD
//˾վ:www.qdtft.com
//Ավhttp://qdtech.taobao.com
//wikiվhttp://www.lcdwiki.com
//˾ṩ֧֣κμ⻶ӭʱѧϰ
//̻() :+86 0755-23594567 
//ֻ:15989313508빤 
//:lcdwiki01@gmail.com    support@lcdwiki.com    goodtft@163.com 
//֧QQ:3002773612  3002778157
//QQȺ:324828016
//:2018/08/22
//汾V1.0
//ȨУؾ
//Copyright(C) ȫӼ޹˾ 2018-2028
//All rights reserved
/****************************************************************************************************
//=========================================Դ================================================//
//     LCDģ                STM32Ƭ
//      VCC                  DC5V/3.3V      //Դ
//      GND                    GND          //Դ
//=======================================Һ߽==========================================//
//ģĬΪSPI
//     LCDģ                STM32Ƭ    
//       SDA                   PF9          //ҺSPIдź
//=======================================Һ߽==========================================//
//     LCDģ 					      STM32Ƭ 
//       LED                   PD6          //ҺźţҪƣ5V3.3V
//       SCK                   PF7          //ҺSPIʱź
//       A0                    PD5          //Һ/ź
//       RESET                 PD12         //Һλź
//       CS                    PD11         //ҺƬѡź
//==================================================================================//
//ģ鲻ܻߴдܣǲҪܣҪд
//	   LCDģ                STM32Ƭ 
//      T_IRQ                  PH11         //жź
//      T_DO                   PG3          //SPI߶ź
//      T_DIN                  PI3          //SPIдź
//      T_CS                   PI8          //Ƭѡź
//      T_CLK                  PH6          //SPIʱź
**************************************************************************************************/			
 /* @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, QD electronic SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
**************************************************************************************************/	
#include "myiic.h"
#include "delay.h"

/*****************************************************************************
 * @name       :void IIC_Init(void)
 * @date       :2018-08-09 
 * @function   :Initialize IIC
 * @parameters :None
 * @retvalue   :None
******************************************************************************/
void IIC_Init(void)
{
    GPIO_InitTypeDef GPIO_Initure;
    
    __HAL_RCC_GPIOH_CLK_ENABLE();   //ʹGPIOHʱ
    
    //PH4,5ʼ
    GPIO_Initure.Pin=GPIO_PIN_4|GPIO_PIN_5;
    GPIO_Initure.Mode=GPIO_MODE_OUTPUT_PP;  //
    GPIO_Initure.Pull=GPIO_PULLUP;          //
    GPIO_Initure.Speed=GPIO_SPEED_FAST;     //
    HAL_GPIO_Init(GPIOH,&GPIO_Initure);
    
    IIC_SDA=1;
    IIC_SCL=1;  
}

/*****************************************************************************
 * @name       :void IIC_Start(void)
 * @date       :2018-08-09 
 * @function   :Generating IIC starting signal
 * @parameters :None
 * @retvalue   :None
******************************************************************************/
void IIC_Start(void)
{
	SDA_OUT();     //sda
	IIC_SDA=1;	  	  
	IIC_SCL=1;
	delay_us(4);
 	IIC_SDA=0;//START:when CLK is high,DATA change form high to low 
	delay_us(4);
	IIC_SCL=0;//ǯסI2Cߣ׼ͻ 
}	

/*****************************************************************************
 * @name       :void IIC_Stop(void)
 * @date       :2018-08-09 
 * @function   :Generating IIC stop signal
 * @parameters :None
 * @retvalue   :None
******************************************************************************/  
void IIC_Stop(void)
{
	SDA_OUT();//sda
	IIC_SCL=0;
	IIC_SDA=0;//STOP:when CLK is high DATA change form low to high
 	delay_us(4);
	IIC_SCL=1; 
	delay_us(4);			
	IIC_SDA=1;//I2C߽ź				   	
}

/*****************************************************************************
 * @name       :u8 IIC_Wait_Ack(void)
 * @date       :2018-08-09 
 * @function   :Wait for the response signal
 * @parameters :None
 * @retvalue   :0-receive response signal successfully
								1-receive response signal unsuccessfully
******************************************************************************/ 
u8 IIC_Wait_Ack(void)
{
	u8 ucErrTime=0;
	SDA_IN();      //SDAΪ  
	IIC_SDA=1;delay_us(1);	   
	IIC_SCL=1;delay_us(1);	 
	while(READ_SDA)
	{
		ucErrTime++;
		if(ucErrTime>250)
		{
			IIC_Stop();
			return 1;
		}
	}
	IIC_SCL=0;//ʱ0 	   
	return 0;  
} 

/*****************************************************************************
 * @name       :void IIC_Ack(void)
 * @date       :2018-08-09 
 * @function   :Generate ACK response signal
 * @parameters :None
 * @retvalue   :None
******************************************************************************/ 
void IIC_Ack(void)
{
	IIC_SCL=0;
	SDA_OUT();
	IIC_SDA=0;
	delay_us(2);
	IIC_SCL=1;
	delay_us(2);
	IIC_SCL=0;
}

/*****************************************************************************
 * @name       :void IIC_NAck(void)
 * @date       :2018-08-09 
 * @function   :Don't generate ACK response signal
 * @parameters :None
 * @retvalue   :None
******************************************************************************/ 	    
void IIC_NAck(void)
{
	IIC_SCL=0;
	SDA_OUT();
	IIC_SDA=1;
	delay_us(2);
	IIC_SCL=1;
	delay_us(2);
	IIC_SCL=0;
}	

/*****************************************************************************
 * @name       :void IIC_Send_Byte(u8 txd)
 * @date       :2018-08-09 
 * @function   :send a byte data by IIC bus
 * @parameters :txd:Data to be sent
 * @retvalue   :None
******************************************************************************/				 				     	  
void IIC_Send_Byte(u8 txd)
{                        
    u8 t;   
	SDA_OUT(); 	    
    IIC_SCL=0;//ʱӿʼݴ
    for(t=0;t<8;t++)
    {              
        IIC_SDA=(txd&0x80)>>7;
        txd<<=1; 	  
		delay_us(2);   //TEA5767ʱǱ
		IIC_SCL=1;
		delay_us(2); 
		IIC_SCL=0;	
		delay_us(2);
    }	 
} 

/*****************************************************************************
 * @name       :u8 IIC_Read_Byte(unsigned char ack)
 * @date       :2018-08-09 
 * @function   :read a byte data by IIC bus
 * @parameters :ack:0-send nACK
									  1-send ACK
 * @retvalue   :Data to be read
******************************************************************************/		    
u8 IIC_Read_Byte(unsigned char ack)
{
	unsigned char i,receive=0;
	SDA_IN();//SDAΪ
    for(i=0;i<8;i++ )
	{
        IIC_SCL=0; 
        delay_us(2);
		IIC_SCL=1;
        receive<<=1;
        if(READ_SDA)receive++;   
		delay_us(1); 
    }					 
    if (!ack)
        IIC_NAck();//nACK
    else
        IIC_Ack(); //ACK   
    return receive;
}



























