
#ifndef _BOARD_CONFIG_H_
#define _BOARD_CONFIG_H_

#include <driver/gpio.h>

// 音频
#define AUDIO_INPUT_SAMPLE_RATE  24000
#define AUDIO_OUTPUT_SAMPLE_RATE 24000

#define AUDIO_INPUT_REFERENCE    true
#define AUDIO_I2S_GPIO_WS GPIO_NUM_4
#define AUDIO_I2S_GPIO_MCLK GPIO_NUM_5
#define AUDIO_I2S_GPIO_BCLK GPIO_NUM_6
#define AUDIO_I2S_GPIO_DIN  GPIO_NUM_17
#define AUDIO_I2S_GPIO_DOUT GPIO_NUM_15

#define AUDIO_CODEC_USE_PCA9557
#define AUDIO_CODEC_I2C_PA_EN  GPIO_NUM_21
#define AUDIO_CODEC_I2C_SDA_PIN  GPIO_NUM_41
#define AUDIO_CODEC_I2C_SCL_PIN  GPIO_NUM_42
#define AUDIO_CODEC_ES8311_ADDR  ES8311_CODEC_DEFAULT_ADDR

// 按键
#define BOOT_BUTTON_GPIO        GPIO_NUM_0

// 屏幕
#define DISPLAY_SPI_HOST SPI3_HOST
#define DISPLAY_SDA GPIO_NUM_10
#define DISPLAY_SCL GPIO_NUM_9
#define DISPLAY_DC GPIO_NUM_8
#define DISPLAY_CS GPIO_NUM_14
#define DISPLAY_RES GPIO_NUM_18
#define DISPLAY_WIDTH   240
#define DISPLAY_HEIGHT  240
#define DISPLAY_SWAP_XY  false
#define DISPLAY_MIRROR_X false
#define DISPLAY_MIRROR_Y false
#define BACKLIGHT_INVERT false
#define DISPLAY_OFFSET_X  0
#define DISPLAY_OFFSET_Y  0
#define DISPLAY_BACKLIGHT_PIN GPIO_NUM_13
#define DISPLAY_BACKLIGHT_OUTPUT_INVERT false

// 电源管理
#define POWER_USB_IN GPIO_NUM_1
#define Power_Control GPIO_NUM_48               // 电源控制引脚
#define Power_Dec GPIO_NUM_47                   // 电源键检测引脚
#define POWER_CBS_ADC_UNIT ADC_UNIT_1           // adc检测公共unit GPIO1
#define POWER_USBIN_ADC_CHANNEL ADC_CHANNEL_0   // 检测usb是否插入 GPIO1
#define POWER_BATTERY_ADC_CHANNEL ADC_CHANNEL_6 // 电池电量检测 GPIO7

#endif // _BOARD_CONFIG_H_
