#ifndef _BOARD_CONFIG_H_
#define _BOARD_CONFIG_H_

// aipi-lite configuration

#include <driver/gpio.h>

#define AUDIO_INPUT_SAMPLE_RATE 24000
#define AUDIO_OUTPUT_SAMPLE_RATE 24000

#define AUDIO_I2S_GPIO_MCLK GPIO_NUM_6   // MCLK
#define AUDIO_I2S_GPIO_WS GPIO_NUM_12    // LRCK
#define AUDIO_I2S_GPIO_BCLK GPIO_NUM_14  // SCLK
#define AUDIO_I2S_GPIO_DIN GPIO_NUM_13   // DIN
#define AUDIO_I2S_GPIO_DOUT GPIO_NUM_11  // DOUT

#define AUDIO_CODEC_PA_PIN GPIO_NUM_9
#define AUDIO_CODEC_I2C_SDA_PIN GPIO_NUM_5
#define AUDIO_CODEC_I2C_SCL_PIN GPIO_NUM_4
#define AUDIO_CODEC_ES8311_ADDR ES8311_CODEC_DEFAULT_ADDR

#define BUILTIN_LED_GPIO GPIO_NUM_46
#define BOOT_BUTTON_GPIO GPIO_NUM_42

#define DISPLAY_WIDTH 128
#define DISPLAY_HEIGHT 128
#define DISPLAY_MIRROR_X true
#define DISPLAY_MIRROR_Y false
#define DISPLAY_SWAP_XY true
#define DISPLAY_INVERT_COLOR false
#define DISPLAY_RGB_ORDER LCD_RGB_ELEMENT_ORDER_BGR

#define DISPLAY_OFFSET_X 0
#define DISPLAY_OFFSET_Y 0

#define DISPLAY_BACKLIGHT_PIN GPIO_NUM_3
#define DISPLAY_BACKLIGHT_OUTPUT_INVERT false

#define DISPLAY_SPI_SCLK_PIN GPIO_NUM_16
#define DISPLAY_SPI_MOSI_PIN GPIO_NUM_17
#define DISPLAY_SPI_CS_PIN GPIO_NUM_15
#define DISPLAY_SPI_DC_PIN GPIO_NUM_7
#define DISPLAY_SPI_RESET_PIN GPIO_NUM_18
#define DISPLAY_SPI_MODE 0
#define DISPLAY_SPI_SCLK_HZ (20 * 1000 * 1000)

#define POWER_BUTTON_GPIO GPIO_NUM_1
#define POWER_CONTROL_PIN GPIO_NUM_10
#define POWER_CHARGE_DETECT_PIN GPIO_NUM_8
#define POWER_ADC_UNIT ADC_UNIT_1
#define POWER_ADC_CHANNEL ADC_CHANNEL_1

#endif  // _BOARD_CONFIG_H_
