/**********************************************************************
 * 本程序只供学习使用，未经作者许可，不得用于其它任何用途
 * 测试硬件：单片机STC12C5A60S2,主频12MHZ
 * 程序说明：ST7789V 8位并口程序
 
 ----------------------------------------------------
 |深圳市千一显示科技有限公司                        |
 |公司网站:www.qytft.com                            |
 |淘宝网站：https://shop580133616.taobao.com        |
 |固话(传真) :+86 0755-27908130                     |
 |业务咨询:18823372746 (徐经理 WX同号)              |
 |业务咨询:15989313508 (冯经理 WX同号)              |
 ----------------------------------------------------

 ----------------------------------------------------
 |我司提供技术支持，任何技术问题欢迎随时交流学习    |
 |技术支持QQ:3597321058                             |
 |技术支持邮箱:qyxskj@126.com                       |
 |技术支持:13723763193（周工 WX同号）               |
 |技术交流QQ群:792027219                            |
 ----------------------------------------------------

 * 接线说明:
 ========================电源引脚接线======================================================        
 |   LCD模块           单片机引脚                                                         |
 |     VCC      --->      3.3V      //电源                                                |
 |     GND      --->      GND       //电源地                                              |  
 |====================控制及数据引脚接线==================================================|
 |   LCD模块 			    单片机引脚                                                          |
 |     CS      --->      P13       //液晶屏片选控制信号（低电平有效）                     |
 |     RS      --->      P12       //液晶屏命令/数据控制信号（低电平：命令，高电平：数据）|
 |     RST     --->      P33       //液晶屏复位控制信号（低电平有效）                     |
 |     WR      --->      P11       //液晶屏写控制信号                                     |
 |     DB8~15  --->      P20~P27   //液晶屏8位并口数据信号                                |                             
 ==========================================================================================
 
 * 创建日期:2020/5/13
 * 版本：V1.0
 * 版权所有，盗版必究。
 * Copyright(C) 深圳市千一显示科技有限公司 2020-2035
 * All rights reserved
**********************************************************************/
#include <reg51.h>
#include <intrins.h>

#define	u8 unsigned char
#define	u16 unsigned int
#define	u32 unsigned long

//////////////////////////////////////////////////////////////////////////////////	  
//定义LCD的尺寸
#define LCD_W 240
#define LCD_H 320

#define SET_X_ADD_CMD 0x2A
#define SET_Y_ADD_CMD 0x2B
#define WR_RAM_CMD 0x2C

//IO连接
#define  LCD_DataPort P2     //8位数据口
sbit LCD_RS = P1^2;  		 //数据/命令切换
sbit LCD_WR = P1^1;		  //写控制
//sbit LCD_RD = P1^0;		     //读控制
sbit LCD_CS = P1^3;		//片选	
sbit LCD_RESET = P3^3;	      //复位 
//sbit LCD_BL=P3^2;		//背光控制，如果不需要控制，接3.3V


//画笔颜色
#define WHITE         	 0xFFFF
#define BLACK         	 0x0000	  
#define BLUE         	 0x001F  
#define BRED             0XF81F
#define GRED 			 0XFFE0
#define GBLUE			 0X07FF
#define RED           	 0xF800
#define MAGENTA       	 0xF81F
#define GREEN         	 0x07E0
#define CYAN          	 0x7FFF
#define YELLOW        	 0xFFE0
#define BROWN 			 0XBC40 //棕色
#define BRRED 			 0XFC07 //棕红色
#define GRAY  			 0X8430 //灰色
#define GRAY0       0xEF7D 
#define GRAY1       0x8410      	//灰色1      00000 000000 00000
#define GRAY2       0x4208 
//GUI颜色

#define DARKBLUE      	 0X01CF	//深蓝色
#define LIGHTBLUE      	 0X7D7C	//浅蓝色  
#define GRAYBLUE       	 0X5458 //灰蓝色
//以上三色为PANEL的颜色 
 
#define LIGHTGREEN     	 0X841F //浅绿色
#define LGRAY 			 0XC618 //浅灰色(PANNEL),窗体背景色

#define LGRAYBLUE        0XA651 //浅灰蓝色(中间层颜色)
#define LBBLUE           0X2B12 //浅棕蓝色(选择条目的反色)