/**********************************************************************
 * ֻѧϰʹãδɣκ;
 * ӲƬCH32F103C8T6,Ƶ72MHZ
 * ˵ST7789V 3ӲSPI
 
 ----------------------------------------------------
 |ǧһʾƼ޹˾                        |
 |˾վ:www.qytft.com                            |
 |Ավhttps://shop580133616.taobao.com        |
 |̻() :+86 0755-27908130                     |
 |ҵѯ:18823372746 (쾭 WXͬ)              |
 |ҵѯ:15989313508 (뾭 WXͬ)              |
 ----------------------------------------------------

 ----------------------------------------------------
 |˾ṩ֧֣κμ⻶ӭʱѧϰ    |
 |֧QQ:3597321058                             |
 |֧:qyxskj@126.com                       |
 |֧:13723763193ܹ WXͬţ               |
 |QQȺ:792027219                            |
 ----------------------------------------------------

 * ˵:
 ========================ԴŽ==========================================        
 |   LCDģ           Ƭ                                             |
 |     VCC      --->      3.3V      //Դ                                    |
 |     GND      --->      GND       //Դ                                  | 
 |====================ƼŽ======================================|
 |   LCDģ 			     Ƭ                                             |
 |     CS       --->      PA4       //ҺƬѡźţ͵ƽЧ        |
 |     RST      --->      PA1       //Һλźţ͵ƽЧ        |
 |     SCL      --->      PA5       //ҺSPIʱź                   |
 |     SDI      --->      PA7       //ҺSPIдź                 |
 |     SDO      --->      PA6       //ҺSPI߶ź                 |
 |     LED      --->      PA15      //Һźţ粻ƣ3.3V|
 |================================================================|
 |	 LCDģ 			     Ƭ                                             |
 |     T_IRQ    --->      PA12      //жź                      |
 |     T_DO     --->      PA2       //SPI߶ź                     |
 |     T_DIN    --->      PA3       //SPIдź                     |
 |     T_CS     --->      PA11      //Ƭѡź                      |
 |     T_CLK    --->      PA8       //SPIʱź                   |
 ==============================================================================
 
 * :2020/5/13
 * 汾V1.0
 * ȨУؾ
 * Copyright(C) ǧһʾƼ޹˾ 2020-2035
 * All rights reserved
**********************************************************************/	
#include "lcd.h"
#include "stdlib.h"
#include "debug.h" 
#include "spi.h"

	   
//LCDҪ
//ĬΪ
_lcd_dev lcddev;

//ɫ,ɫ
u16 POINT_COLOR = 0x0000,BACK_COLOR = 0xFFFF;  
u16 DeviceCode;	 

/*****************************************************************************
 * @name       :void LCD_WR_REG(u8 data)
 * @date       :2018-08-09 
 * @function   :Write an 8-bit command to the LCD screen
 * @parameters :data:Command value to be written
 * @retvalue   :None
******************************************************************************/
void LCD_WR_REG(u8 data)
{ 
   LCD_CS_CLR; 
	 SPI_WriteByte(SPI1,(u16)(data<<7)|0x0000);
   LCD_CS_SET;	
}

/*****************************************************************************
 * @name       :void LCD_WR_DATA(u8 data)
 * @date       :2018-08-09 
 * @function   :Write an 8-bit data to the LCD screen
 * @parameters :data:data value to be written
 * @retvalue   :None
******************************************************************************/
void LCD_WR_DATA(u8 data)
{
   LCD_CS_CLR;
	 SPI_WriteByte(SPI1,(u16)(data<<7)|0x8000);
   LCD_CS_SET;
}

/*****************************************************************************
 * @name       :void LCD_WriteReg(u8 LCD_Reg, u16 LCD_RegValue)
 * @date       :2018-08-09 
 * @function   :Write data into registers
 * @parameters :LCD_Reg:Register address
                LCD_RegValue:Data to be written
 * @retvalue   :None
******************************************************************************/
void LCD_WriteReg(u8 LCD_Reg, u16 LCD_RegValue)
{	
	LCD_WR_REG(LCD_Reg);  
	LCD_WR_DATA(LCD_RegValue);	    		 
}	   

/*****************************************************************************
 * @name       :void LCD_WriteRAM_Prepare(void)
 * @date       :2018-08-09 
 * @function   :Write GRAM
 * @parameters :None
 * @retvalue   :None
******************************************************************************/	 
void LCD_WriteRAM_Prepare(void)
{
	LCD_WR_REG(lcddev.wramcmd);
}	 

/*****************************************************************************
 * @name       :void Lcd_WriteData_16Bit(u16 Data)
 * @date       :2018-08-09 
 * @function   :Write an 16-bit command to the LCD screen
 * @parameters :Data:Data to be written
 * @retvalue   :None
******************************************************************************/	 
void Lcd_WriteData_16Bit(u16 Data)
{	
		LCD_WR_DATA(Data>>8);
		LCD_WR_DATA(Data);
}

/*****************************************************************************
 * @name       :void LCD_DrawPoint(u16 x,u16 y)
 * @date       :2018-08-09 
 * @function   :Write a pixel data at a specified location
 * @parameters :x:the x coordinate of the pixel
                y:the y coordinate of the pixel
 * @retvalue   :None
******************************************************************************/	
void LCD_DrawPoint(u16 x,u16 y)
{
	LCD_SetCursor(x,y);//ùλ 
	Lcd_WriteData_16Bit(POINT_COLOR); 
}

/*****************************************************************************
 * @name       :void LCD_Clear(u16 Color)
 * @date       :2018-08-09 
 * @function   :Full screen filled LCD screen
 * @parameters :color:Filled color
 * @retvalue   :None
******************************************************************************/	
void LCD_Clear(u16 Color)
{
  unsigned int i,m;  
	LCD_SetWindows(0,0,lcddev.width-1,lcddev.height-1);   
	for(i=0;i<lcddev.height;i++)
	{
    for(m=0;m<lcddev.width;m++)
    {	
			Lcd_WriteData_16Bit(Color);
		}
	}
} 

/*****************************************************************************
 * @name       :void LCD_Clear(u16 Color)
 * @date       :2018-08-09 
 * @function   :Initialization LCD screen GPIO
 * @parameters :None
 * @retvalue   :None
******************************************************************************/	
void LCD_GPIOInit(void)
{
	GPIO_InitTypeDef  GPIO_InitStructure;	      
	RCC_APB2PeriphClockCmd( RCC_APB2Periph_GPIOA ,ENABLE);	//ʹGPIOAʱ
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1| GPIO_Pin_4| GPIO_Pin_15;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;   //
	GPIO_Init(GPIOA, &GPIO_InitStructure);//ʼ
}

/*****************************************************************************
 * @name       :void LCD_RESET(void)
 * @date       :2018-08-09 
 * @function   :Reset LCD screen
 * @parameters :None
 * @retvalue   :None
******************************************************************************/	
void LCD_RESET(void)
{
	LCD_RST_CLR;
	Delay_Ms(100);	
	LCD_RST_SET;
	Delay_Ms(50);
}

/*****************************************************************************
 * @name       :void LCD_RESET(void)
 * @date       :2018-08-09 
 * @function   :Initialization LCD screen
 * @parameters :None
 * @retvalue   :None
******************************************************************************/	 	 
void LCD_Init(void)
{  
	SPI1_Init(); //ӲSPI1ʼ
	LCD_GPIOInit();//LCD GPIOʼ										 
 	LCD_RESET(); //LCD λ
//*************ST7789Vʼ**********//
	Delay_Ms(120);
//------------------------Display Setting-------------------------------------//
	LCD_WR_REG(0x36);
	LCD_WR_DATA(0x00);
	LCD_WR_REG(0x3a);
	LCD_WR_DATA(0x55);
//-------------------ST7789V Frame rate setting-----------------//
	LCD_WR_REG(0xb2);
	LCD_WR_DATA(0x0c);
	LCD_WR_DATA(0x0c);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x33);
	LCD_WR_DATA(0x33);
	LCD_WR_REG(0xb7);
	LCD_WR_DATA(0x35);
//---------------------------------------------------//
	LCD_WR_REG(0xbb);
	LCD_WR_DATA(0x2B);
	LCD_WR_REG(0xc0);
	LCD_WR_DATA(0x2c);
	LCD_WR_REG(0xc2);
	LCD_WR_DATA(0x01);
	LCD_WR_REG(0xc3);
	LCD_WR_DATA(0x12);
	LCD_WR_REG(0xc4);
	LCD_WR_DATA(0x20);
	LCD_WR_REG(0xc6);
	LCD_WR_DATA(0x0f);
	LCD_WR_REG(0xd0);
	LCD_WR_DATA(0xa4);
	LCD_WR_DATA(0xa1);
/* Positive Voltage Gamma Control */
	LCD_WR_REG( 0xE0);
	LCD_WR_DATA(0xd0);
	LCD_WR_DATA(0x04);
	LCD_WR_DATA(0x0d);
	LCD_WR_DATA(0x11);
	LCD_WR_DATA(0x13);
	LCD_WR_DATA(0x2b);
	LCD_WR_DATA(0x3f);
	LCD_WR_DATA(0x54);
	LCD_WR_DATA(0x4c);
	LCD_WR_DATA(0x18);
	LCD_WR_DATA(0x0d);
	LCD_WR_DATA(0x0b);
	LCD_WR_DATA(0x1f);
	LCD_WR_DATA(0x23);
/* Negative Voltage Gamma Control */
	LCD_WR_REG( 0xE1);
	LCD_WR_DATA(0xd0);
	LCD_WR_DATA(0x04);
	LCD_WR_DATA(0x0c);
	LCD_WR_DATA(0x11);
	LCD_WR_DATA(0x13);
	LCD_WR_DATA(0x2c);
	LCD_WR_DATA(0x3f);
	LCD_WR_DATA(0x44);
	LCD_WR_DATA(0x51);
	LCD_WR_DATA(0x2f);
	LCD_WR_DATA(0x1f);
	LCD_WR_DATA(0x1f);
	LCD_WR_DATA(0x20);
	LCD_WR_DATA(0x23);
/*Sleep out*/
	LCD_WR_REG( 0x11);
	Delay_Ms(120);
/*Display on*/
	LCD_WR_REG( 0x29);
  LCD_direction(USE_HORIZONTAL);//LCDʾ
	LCD_LED=1;//	 
	LCD_Clear(WHITE);//ȫɫ
}
 
/*****************************************************************************
 * @name       :void LCD_SetWindows(u16 xStar, u16 yStar,u16 xEnd,u16 yEnd)
 * @date       :2018-08-09 
 * @function   :Setting LCD display window
 * @parameters :xStar:the bebinning x coordinate of the LCD display window
								yStar:the bebinning y coordinate of the LCD display window
								xEnd:the endning x coordinate of the LCD display window
								yEnd:the endning y coordinate of the LCD display window
 * @retvalue   :None
******************************************************************************/ 
void LCD_SetWindows(u16 xStar, u16 yStar,u16 xEnd,u16 yEnd)
{	
	LCD_WR_REG(lcddev.setxcmd);	
	LCD_WR_DATA(xStar>>8);
	LCD_WR_DATA(0x00FF&xStar);		
	LCD_WR_DATA(xEnd>>8);
	LCD_WR_DATA(0x00FF&xEnd);

	LCD_WR_REG(lcddev.setycmd);	
	LCD_WR_DATA(yStar>>8);
	LCD_WR_DATA(0x00FF&yStar);		
	LCD_WR_DATA(yEnd>>8);
	LCD_WR_DATA(0x00FF&yEnd);

	LCD_WriteRAM_Prepare();	//ʼдGRAM			
}   

/*****************************************************************************
 * @name       :void LCD_SetCursor(u16 Xpos, u16 Ypos)
 * @date       :2018-08-09 
 * @function   :Set coordinate value
 * @parameters :Xpos:the  x coordinate of the pixel
								Ypos:the  y coordinate of the pixel
 * @retvalue   :None
******************************************************************************/ 
void LCD_SetCursor(u16 Xpos, u16 Ypos)
{	  	    			
	LCD_SetWindows(Xpos,Ypos,Xpos,Ypos);	
} 

/*****************************************************************************
 * @name       :void LCD_direction(u8 direction)
 * @date       :2018-08-09 
 * @function   :Setting the display direction of LCD screen
 * @parameters :direction:0-0 degree
                          1-90 degree
													2-180 degree
													3-270 degree
 * @retvalue   :None
******************************************************************************/ 
void LCD_direction(u8 direction)
{ 
			lcddev.setxcmd=0x2A;
			lcddev.setycmd=0x2B;
			lcddev.wramcmd=0x2C;
	switch(direction){		  
		case 0:						 	 		
			lcddev.width=LCD_W;
			lcddev.height=LCD_H;		
			LCD_WriteReg(0x36,0);
		break;
		case 1:
			lcddev.width=LCD_H;
			lcddev.height=LCD_W;
			LCD_WriteReg(0x36,(1<<5)|(1<<6));
		break;
		case 2:						 	 		
			lcddev.width=LCD_W;
			lcddev.height=LCD_H;	
			LCD_WriteReg(0x36,(1<<7)|(1<<6));
		break;
		case 3:
			lcddev.width=LCD_H;
			lcddev.height=LCD_W;
			LCD_WriteReg(0x36,(1<<7)|(1<<5));
		break;	
		default:break;
	}		
}
