/**********************************************************************
 * ֻѧϰʹãδɣκ;
 * ӲƬCH32F103C8T6,Ƶ72MHZ
 * ˵ST7775R 3ӲSPI
 
 ----------------------------------------------------
 |ǧһʾƼ޹˾                        |
 |˾վ:www.qytft.com                            |
 |Ավhttps://shop580133616.taobao.com        |
 |̻() :+86 0755-27908130                     |
 |ҵѯ:18823372746 (쾭 WXͬ)              |
 |ҵѯ:15989313508 (뾭 WXͬ)              |
 ----------------------------------------------------

 ----------------------------------------------------
 |˾ṩ֧֣κμ⻶ӭʱѧϰ    |
 |֧QQ:3597321058                             |
 |֧:qyxskj@126.com                       |
 |֧:13723763193ܹ WXͬţ               |
 |QQȺ:792027219                            |
 ----------------------------------------------------

 * ˵:
 ========================ԴŽ==========================================        
 |   LCDģ           Ƭ                                             |
 |     VCC      --->      3.3V      //Դ                                    |
 |     GND      --->      GND       //Դ                                  | 
 |====================ƼŽ======================================|
 |   LCDģ 			     Ƭ                                             |
 |     CS       --->      PA4       //ҺƬѡźţ͵ƽЧ        |
 |     RST      --->      PA1       //Һλźţ͵ƽЧ        |
 |     SCL      --->      PA5       //ҺSPIʱź                   |
 |     SDI      --->      PA7       //ҺSPIдź                 |
 |     SDO      --->      PA6       //ҺSPI߶ź                 |
 |     LED      --->      PA15      //Һźţ粻ƣ3.3V|
 |================================================================|
 |	 LCDģ 			     Ƭ                                             |
 |     T_IRQ    --->      PA12      //жź                      |
 |     T_DO     --->      PA2       //SPI߶ź                     |
 |     T_DIN    --->      PA3       //SPIдź                     |
 |     T_CS     --->      PA11      //Ƭѡź                      |
 |     T_CLK    --->      PA8       //SPIʱź                   |
 ==============================================================================
 
 * :2020/5/13
 * 汾V1.0
 * ȨУؾ
 * Copyright(C) ǧһʾƼ޹˾ 2020-2035
 * All rights reserved
**********************************************************************/	
#include "lcd.h"
#include "stdlib.h"
#include "debug.h" 
#include "spi.h"

	   
//LCDҪ
//ĬΪ
_lcd_dev lcddev;

//ɫ,ɫ
u16 POINT_COLOR = 0x0000,BACK_COLOR = 0xFFFF;  
u16 DeviceCode;	 

/*****************************************************************************
 * @name       :void LCD_WR_REG(u8 data)
 * @date       :2018-08-09 
 * @function   :Write an 8-bit command to the LCD screen
 * @parameters :data:Command value to be written
 * @retvalue   :None
******************************************************************************/
void LCD_WR_REG(u16 data)
{ 
   LCD_CS_CLR;
	 SPI_WriteBit(0);
	 SPI_Write_Byte(data>>8);
	 SPI_WriteBit(0);
	 SPI_Write_Byte(data);
   LCD_CS_SET;	
}

/*****************************************************************************
 * @name       :void LCD_WR_DATA(u8 data)
 * @date       :2018-08-09 
 * @function   :Write an 8-bit data to the LCD screen
 * @parameters :data:data value to be written
 * @retvalue   :None
******************************************************************************/
void LCD_WR_DATA(u16 data)
{
   LCD_CS_CLR;
	 SPI_WriteBit(1);
	 SPI_Write_Byte(data>>8);
	 SPI_WriteBit(1);
	 SPI_Write_Byte(data);
   LCD_CS_SET;
}

/*****************************************************************************
 * @name       :void LCD_WriteReg(u8 LCD_Reg, u16 LCD_RegValue)
 * @date       :2018-08-09 
 * @function   :Write data into registers
 * @parameters :LCD_Reg:Register address
                LCD_RegValue:Data to be written
 * @retvalue   :None
******************************************************************************/
void LCD_WriteReg(u16 LCD_Reg, u16 LCD_RegValue)
{	
	LCD_WR_REG(LCD_Reg);  
	LCD_WR_DATA(LCD_RegValue);	    		 
}	   

/*****************************************************************************
 * @name       :void LCD_WriteRAM_Prepare(void)
 * @date       :2018-08-09 
 * @function   :Write GRAM
 * @parameters :None
 * @retvalue   :None
******************************************************************************/	 
void LCD_WriteRAM_Prepare(void)
{
	LCD_WR_REG(lcddev.wramcmd);
}	 

/*****************************************************************************
 * @name       :void Lcd_WriteData_16Bit(u16 Data)
 * @date       :2018-08-09 
 * @function   :Write an 16-bit command to the LCD screen
 * @parameters :Data:Data to be written
 * @retvalue   :None
******************************************************************************/	 
void Lcd_WriteData_16Bit(u16 Data)
{	
		//LCD_WR_DATA(Data>>8);
		LCD_WR_DATA(Data);
}

/*****************************************************************************
 * @name       :void LCD_DrawPoint(u16 x,u16 y)
 * @date       :2018-08-09 
 * @function   :Write a pixel data at a specified location
 * @parameters :x:the x coordinate of the pixel
                y:the y coordinate of the pixel
 * @retvalue   :None
******************************************************************************/	
void LCD_DrawPoint(u16 x,u16 y)
{
	LCD_SetCursor(x,y);//ùλ 
	Lcd_WriteData_16Bit(POINT_COLOR); 
}

/*****************************************************************************
 * @name       :void LCD_Clear(u16 Color)
 * @date       :2018-08-09 
 * @function   :Full screen filled LCD screen
 * @parameters :color:Filled color
 * @retvalue   :None
******************************************************************************/	
void LCD_Clear(u16 Color)
{
  unsigned int i,m;  
	LCD_SetWindows(0,0,lcddev.width-1,lcddev.height-1);   
	for(i=0;i<lcddev.height;i++)
	{
    for(m=0;m<lcddev.width;m++)
    {	
			Lcd_WriteData_16Bit(Color);
		}
	}
} 

/*****************************************************************************
 * @name       :void LCD_Clear(u16 Color)
 * @date       :2018-08-09 
 * @function   :Initialization LCD screen GPIO
 * @parameters :None
 * @retvalue   :None
******************************************************************************/	
void LCD_GPIOInit(void)
{
	GPIO_InitTypeDef  GPIO_InitStructure;	      
	RCC_APB2PeriphClockCmd( RCC_APB2Periph_GPIOA ,ENABLE);	//ʹGPIOAʱ
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1| GPIO_Pin_4| GPIO_Pin_15;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;   //
	GPIO_Init(GPIOA, &GPIO_InitStructure);//ʼ
}

/*****************************************************************************
 * @name       :void LCD_RESET(void)
 * @date       :2018-08-09 
 * @function   :Reset LCD screen
 * @parameters :None
 * @retvalue   :None
******************************************************************************/	
void LCD_RESET(void)
{
	LCD_RST_CLR;
	Delay_Ms(100);	
	LCD_RST_SET;
	Delay_Ms(50);
}

/*****************************************************************************
 * @name       :void LCD_RESET(void)
 * @date       :2018-08-09 
 * @function   :Initialization LCD screen
 * @parameters :None
 * @retvalue   :None
******************************************************************************/	 	 
void LCD_Init(void)
{  
	Spi_Gpio_Init();
	LCD_GPIOInit();//LCD GPIOʼ										 
 	LCD_RESET(); //LCD λ
//*************ST7775Rʼ**********//
	LCD_WR_REG(0x0001);
	LCD_WR_DATA(0x011C);
	LCD_WR_REG(0x0002);
	LCD_WR_DATA(0x0100);
	LCD_WR_REG(0x0003);
	LCD_WR_DATA(0x1030);
	LCD_WR_REG(0x0008);
	LCD_WR_DATA(0x0808);
	LCD_WR_REG(0x000C);
	LCD_WR_DATA(0x0000);
	LCD_WR_REG(0x000F);
	LCD_WR_DATA(0x0001);
	LCD_WR_REG(0x0020);
	LCD_WR_DATA(0x0000);
	LCD_WR_REG(0x0021);
	LCD_WR_DATA(0x0000);
	//-----------------------------------End Display Control setting-----------------------------------------//
	//-------------------------------- Power Control Registers Initial --------------------------------------//
	LCD_WR_REG(0x0010);
	LCD_WR_DATA(0x0000);
	LCD_WR_REG(0x0011);
	LCD_WR_DATA(0x1000);
	//---------------------------------End Power Control Registers Initial -------------------------------//
	Delay_Ms(100);
	//----------------------------------Display Windows 176 X 220----------------------------------------//
	LCD_WR_REG(0x0030);
	LCD_WR_DATA(0x0000);
	LCD_WR_REG(0x0031);
	LCD_WR_DATA(0x00DB);
	LCD_WR_REG(0x0032);
	LCD_WR_DATA(0x0000);
	LCD_WR_REG(0x0033);
	LCD_WR_DATA(0x0000);
	LCD_WR_REG(0x0034);
	LCD_WR_DATA(0x00DB);
	LCD_WR_REG(0x0035);
	LCD_WR_DATA(0x0000);
	LCD_WR_REG(0x0036);
	LCD_WR_DATA(0x00AF);
	LCD_WR_REG(0x0037);
	LCD_WR_DATA(0x0000);
	LCD_WR_REG(0x0038);
	LCD_WR_DATA(0x00DB);
	LCD_WR_REG(0x0039);
	LCD_WR_DATA(0x0000);
	//----------------------------------End Display Windows 176 X 220----------------------------------//
	Delay_Ms(10);
	LCD_WR_REG(0x00ff);
	LCD_WR_DATA(0x0003);
	//-------------------------------------Gamma Cluster Setting-------------------------------------------//
	LCD_WR_REG(0x0050);
	LCD_WR_DATA(0x0203);
	LCD_WR_REG(0x0051);
	LCD_WR_DATA(0x0a09);
	LCD_WR_REG(0x0052);
	LCD_WR_DATA(0x0005);
	LCD_WR_REG(0x0053);
	LCD_WR_DATA(0x1021);
	LCD_WR_REG(0x0054);
	LCD_WR_DATA(0x0602);
	LCD_WR_REG(0x0055);
	LCD_WR_DATA(0x0003);
	LCD_WR_REG(0x0056);
	LCD_WR_DATA(0x0703);
	LCD_WR_REG(0x0057);
	LCD_WR_DATA(0x0507);
	LCD_WR_REG(0x0058);
	LCD_WR_DATA(0x1021);
	LCD_WR_REG(0x0059);
	LCD_WR_DATA(0x0703);
	//---------------------------------------End Gamma Setting---------------------------------------------//
	//--------------------------------------Vcom Setting---------------------------------------------//
	LCD_WR_REG(0x00B0);
	LCD_WR_DATA(0x2301);
	LCD_WR_REG(0x00B1); //Աȶ
	LCD_WR_DATA(0x0000);
	//---------------------------------------End Vcom Setting---------------------------------------------//
	LCD_WR_REG(0x00ff);
	LCD_WR_DATA(0x0000);
	LCD_WR_REG(0x0007);
	LCD_WR_DATA(0x1017);
	Delay_Ms(200); //Delay 200ms
  LCD_direction(USE_HORIZONTAL);//LCDʾ
	LCD_LED=1;//	 
	LCD_Clear(WHITE);//ȫɫ
}
 
/*****************************************************************************
 * @name       :void LCD_SetWindows(u16 xStar, u16 yStar,u16 xEnd,u16 yEnd)
 * @date       :2018-08-09 
 * @function   :Setting LCD display window
 * @parameters :xStar:the bebinning x coordinate of the LCD display window
								yStar:the bebinning y coordinate of the LCD display window
								xEnd:the endning x coordinate of the LCD display window
								yEnd:the endning y coordinate of the LCD display window
 * @retvalue   :None
******************************************************************************/ 
void LCD_SetWindows(u16 xStar, u16 yStar,u16 xEnd,u16 yEnd)
{	
	u16 x,y,tmp;
	switch(lcddev.dir)
	{
		case 0:
			x = xStar;
			y = yStar;
			break;
		case 1:
			tmp = yStar;
			yStar = xStar;
			xStar = LCD_W-1-yEnd;
			yEnd = xEnd;
			xEnd = LCD_W-1-tmp;
			x = xEnd;
			y = yStar;
			break;
		case 2:
			tmp = xStar;
			xStar = LCD_W-1-xEnd;
			xEnd = LCD_W-1-tmp;
			tmp = yStar;
			yStar = LCD_H-1-yEnd;
			yEnd = LCD_H-1-tmp;
			x = xEnd;
			y = yEnd;
			break;
		case 3:
			tmp = xStar;
			xStar = yStar;
			yStar = LCD_H-1-xEnd;
			xEnd = yEnd;
			yEnd = LCD_H-1-tmp;
			x = xStar;
			y = yEnd;
			break;
		default:
			break;
	}
	LCD_WriteReg(0x0036, xEnd);
	LCD_WriteReg(0x0037, xStar);
	LCD_WriteReg(0x0038, yEnd);
	LCD_WriteReg(0x0039, yStar);
	LCD_WriteReg(lcddev.setxcmd, x);
	LCD_WriteReg(lcddev.setycmd, y);
	LCD_WriteRAM_Prepare();	//ʼдGRAM		
}   

/*****************************************************************************
 * @name       :void LCD_SetCursor(u16 Xpos, u16 Ypos)
 * @date       :2018-08-09 
 * @function   :Set coordinate value
 * @parameters :Xpos:the  x coordinate of the pixel
								Ypos:the  y coordinate of the pixel
 * @retvalue   :None
******************************************************************************/ 
void LCD_SetCursor(u16 Xpos, u16 Ypos)
{	  	    			
	LCD_SetWindows(Xpos,Ypos,Xpos,Ypos);	
} 

/*****************************************************************************
 * @name       :void LCD_direction(u8 direction)
 * @date       :2018-08-09 
 * @function   :Setting the display direction of LCD screen
 * @parameters :direction:0-0 degree
                          1-90 degree
													2-180 degree
													3-270 degree
 * @retvalue   :None
******************************************************************************/ 
void LCD_direction(u8 direction)
{ 
			lcddev.dir = direction&3;
			lcddev.setxcmd=0x0020;
			lcddev.setycmd=0x0021;
			lcddev.wramcmd=0x0022;
	switch(lcddev.dir){		  
		case 0:						 	 		
			lcddev.width=LCD_W;
			lcddev.height=LCD_H;		
			LCD_WriteReg(0x0003,0x1030);
		break;
		case 1:
			lcddev.width=LCD_H;
			lcddev.height=LCD_W;
			LCD_WriteReg(0x0003,0x1028);
		break;
		case 2:						 	 		
			lcddev.width=LCD_W;
			lcddev.height=LCD_H;	
			LCD_WriteReg(0x0003,0x1000);
		break;
		case 3:
			lcddev.width=LCD_H;
			lcddev.height=LCD_W;
			LCD_WriteReg(0x0003,0x1018);
		break;	
		default:break;
	}		
}
