/**********************************************************************
 * ֻѧϰʹãδɣκ;
 * ӲƬCH32F103C8T6,Ƶ72MHZ
 * ˵ST7735S 4ӲSPI
 
 ----------------------------------------------------
 |ǧһʾƼ޹˾                        |
 |˾վ:www.qytft.com                            |
 |Ավhttps://shop580133616.taobao.com        |
 |̻() :+86 0755-27908130                     |
 |ҵѯ:18823372746 (쾭 WXͬ)              |
 |ҵѯ:15989313508 (뾭 WXͬ)              |
 ----------------------------------------------------

 ----------------------------------------------------
 |˾ṩ֧֣κμ⻶ӭʱѧϰ    |
 |֧QQ:3597321058                             |
 |֧:qyxskj@126.com                       |
 |֧:13723763193ܹ WXͬţ               |
 |QQȺ:792027219                            |
 ----------------------------------------------------

 * ˵:
 ========================ԴŽ=======================================================        
 |   LCDģ           Ƭ                                                          |
 |     VCC      --->      3.3V      //Դ                                                 |
 |     GND      --->      GND       //Դ                                               |  
 |====================ƼŽ===================================================|
 |   LCDģ 			     Ƭ                                                          |
 |     CS       --->      PA4       //ҺƬѡźţ͵ƽЧ                     |
 |     RST      --->      PA1       //Һλźţ͵ƽЧ                     |
 |     RS       --->      PA10      //Һ/ݿźţ͵ƽߵƽݣ|
 |     SCL      --->      PA5       //ҺSPIʱź                                |
 |     SDI      --->      PA7       //ҺSPIдź                              |
 |     SDO      --->      PA6       //ҺSPI߶ź                              |
 |     LED      --->      PA15      //Һźţ粻ƣ3.3V             |
 ===========================================================================================
 
 * :2020/5/13
 * 汾V1.0
 * ȨУؾ
 * Copyright(C) ǧһʾƼ޹˾ 2020-2035
 * All rights reserved
**********************************************************************/
#include "lcd.h"
#include "stdlib.h"
#include "debug.h" 
#include "spi.h"

	   
//LCDҪ
//ĬΪ
_lcd_dev lcddev;

//ɫ,ɫ
u16 POINT_COLOR = 0x0000,BACK_COLOR = 0xFFFF;  
u16 DeviceCode;	 

/*****************************************************************************
 * @name       :void LCD_WR_REG(u8 data)
 * @date       :2018-08-09 
 * @function   :Write an 8-bit command to the LCD screen
 * @parameters :data:Command value to be written
 * @retvalue   :None
******************************************************************************/
void LCD_WR_REG(u8 data)
{ 
   LCD_CS_CLR;  
	 LCD_RS_CLR;	  
   SPI_WriteByte(SPI1,data);
   LCD_CS_SET;	
}

/*****************************************************************************
 * @name       :void LCD_WR_DATA(u8 data)
 * @date       :2018-08-09 
 * @function   :Write an 8-bit data to the LCD screen
 * @parameters :data:data value to be written
 * @retvalue   :None
******************************************************************************/
void LCD_WR_DATA(u8 data)
{
   LCD_CS_CLR;
	 LCD_RS_SET;
   SPI_WriteByte(SPI1,data);
   LCD_CS_SET;
}

/*****************************************************************************
 * @name       :void LCD_WriteReg(u8 LCD_Reg, u16 LCD_RegValue)
 * @date       :2018-08-09 
 * @function   :Write data into registers
 * @parameters :LCD_Reg:Register address
                LCD_RegValue:Data to be written
 * @retvalue   :None
******************************************************************************/
void LCD_WriteReg(u8 LCD_Reg, u16 LCD_RegValue)
{	
	LCD_WR_REG(LCD_Reg);  
	LCD_WR_DATA(LCD_RegValue);	    		 
}	   

/*****************************************************************************
 * @name       :void LCD_WriteRAM_Prepare(void)
 * @date       :2018-08-09 
 * @function   :Write GRAM
 * @parameters :None
 * @retvalue   :None
******************************************************************************/	 
void LCD_WriteRAM_Prepare(void)
{
	LCD_WR_REG(lcddev.wramcmd);
}	 

/*****************************************************************************
 * @name       :void Lcd_WriteData_16Bit(u16 Data)
 * @date       :2018-08-09 
 * @function   :Write an 16-bit command to the LCD screen
 * @parameters :Data:Data to be written
 * @retvalue   :None
******************************************************************************/	 
void Lcd_WriteData_16Bit(u16 Data)
{	
	 LCD_CS_CLR;
   LCD_RS_SET;  
   SPI_WriteByte(SPI1,Data>>8);
	 SPI_WriteByte(SPI1,Data);
	 LCD_CS_SET;
}

/*****************************************************************************
 * @name       :void LCD_DrawPoint(u16 x,u16 y)
 * @date       :2018-08-09 
 * @function   :Write a pixel data at a specified location
 * @parameters :x:the x coordinate of the pixel
                y:the y coordinate of the pixel
 * @retvalue   :None
******************************************************************************/	
void LCD_DrawPoint(u16 x,u16 y)
{
	LCD_SetCursor(x,y);//ùλ 
	Lcd_WriteData_16Bit(POINT_COLOR); 
}

/*****************************************************************************
 * @name       :void LCD_Clear(u16 Color)
 * @date       :2018-08-09 
 * @function   :Full screen filled LCD screen
 * @parameters :color:Filled color
 * @retvalue   :None
******************************************************************************/	
void LCD_Clear(u16 Color)
{
  unsigned int i,m;  
	LCD_SetWindows(0,0,lcddev.width-1,lcddev.height-1);   
	LCD_CS_CLR;
	LCD_RS_SET;
	for(i=0;i<lcddev.height;i++)
	{
    for(m=0;m<lcddev.width;m++)
    {	
			SPI_WriteByte(SPI1,Color>>8);
			SPI_WriteByte(SPI1,Color);
		}
	}
	 LCD_CS_SET;
} 

/*****************************************************************************
 * @name       :void LCD_Clear(u16 Color)
 * @date       :2018-08-09 
 * @function   :Initialization LCD screen GPIO
 * @parameters :None
 * @retvalue   :None
******************************************************************************/	
void LCD_GPIOInit(void)
{
	GPIO_InitTypeDef  GPIO_InitStructure;	      
	RCC_APB2PeriphClockCmd( RCC_APB2Periph_GPIOA ,ENABLE);	//ʹGPIOAʱ
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1|GPIO_Pin_4|GPIO_Pin_10|GPIO_Pin_15;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;   //
	GPIO_Init(GPIOA, &GPIO_InitStructure);//ʼ
}

/*****************************************************************************
 * @name       :void LCD_RESET(void)
 * @date       :2018-08-09 
 * @function   :Reset LCD screen
 * @parameters :None
 * @retvalue   :None
******************************************************************************/	
void LCD_RESET(void)
{
	LCD_RST_CLR;
	Delay_Ms(100);	
	LCD_RST_SET;
	Delay_Ms(50);
}

/*****************************************************************************
 * @name       :void LCD_RESET(void)
 * @date       :2018-08-09 
 * @function   :Initialization LCD screen
 * @parameters :None
 * @retvalue   :None
******************************************************************************/	 	 
void LCD_Init(void)
{  
	SPI1_Init(); //ӲSPI1ʼ
	LCD_GPIOInit();//LCD GPIOʼ										 
 	LCD_RESET(); //LCD λ
//*************ST7735Sʼ**********//
	Delay_Ms(120);
//--------------------------------End ST7735S Reset Sequence --------------------------------------//
	LCD_WR_REG(0x11); //Sleep out
	Delay_Ms(120); //Delay 120ms
	//------------------------------------ST7735S Frame Rate-----------------------------------------//
	LCD_WR_REG(0xB1);
	LCD_WR_DATA(0x05);
	LCD_WR_DATA(0x3C);
	LCD_WR_DATA(0x3C);
	LCD_WR_REG(0xB2);
	LCD_WR_DATA(0x05);
	LCD_WR_DATA(0x3C);
	LCD_WR_DATA(0x3C);
	LCD_WR_REG(0xB3);
	LCD_WR_DATA(0x05);
	LCD_WR_DATA(0x3C);
	LCD_WR_DATA(0x3C);
	LCD_WR_DATA(0x05);
	LCD_WR_DATA(0x3C);
	LCD_WR_DATA(0x3C);
//------------------------------------End ST7735S Frame Rate-----------------------------------------//
	LCD_WR_REG(0xB4); //Dot inversion
	LCD_WR_DATA(0x03);
//------------------------------------ST7735S Power Sequence-----------------------------------------//
	LCD_WR_REG(0xC0);
	LCD_WR_DATA(0x28);
	LCD_WR_DATA(0x08);
	LCD_WR_DATA(0x04);
	LCD_WR_REG(0xC1);
	LCD_WR_DATA(0XC0);
	LCD_WR_REG(0xC2);
	LCD_WR_DATA(0x0D);
	LCD_WR_DATA(0x00);
	LCD_WR_REG(0xC3);
	LCD_WR_DATA(0x8D);
	LCD_WR_DATA(0x2A);
	LCD_WR_REG(0xC4);
	LCD_WR_DATA(0x8D);
	LCD_WR_DATA(0xEE);
//---------------------------------End ST7735S Power Sequence-------------------------------------//
	LCD_WR_REG(0xC5); //VCOM
	LCD_WR_DATA(0x10);
	LCD_WR_REG(0x36); //MX, MY, RGB mode
	LCD_WR_DATA(0x00);
//------------------------------------ST7735S Gamma Sequence-----------------------------------------//
	LCD_WR_REG(0xE0);
	LCD_WR_DATA(0x04);
	LCD_WR_DATA(0x22);
	LCD_WR_DATA(0x07);
	LCD_WR_DATA(0x0A);
	LCD_WR_DATA(0x2E);
	LCD_WR_DATA(0x30);
	LCD_WR_DATA(0x25);
	LCD_WR_DATA(0x2A);
	LCD_WR_DATA(0x28);
	LCD_WR_DATA(0x26);
	LCD_WR_DATA(0x2E);
	LCD_WR_DATA(0x3A);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x01);
	LCD_WR_DATA(0x03);
	LCD_WR_DATA(0x13);
	LCD_WR_REG(0xE1);
	LCD_WR_DATA(0x04);
	LCD_WR_DATA(0x16);
	LCD_WR_DATA(0x06);
	LCD_WR_DATA(0x0D);
	LCD_WR_DATA(0x2D);
	LCD_WR_DATA(0x26);
	LCD_WR_DATA(0x23);
	LCD_WR_DATA(0x27);
	LCD_WR_DATA(0x27);
	LCD_WR_DATA(0x25);
	LCD_WR_DATA(0x2D);
	LCD_WR_DATA(0x3B);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x01);
	LCD_WR_DATA(0x04);
	LCD_WR_DATA(0x13);
//------------------------------------End ST7735S Gamma Sequence-----------------------------------------//
	LCD_WR_REG(0x3A); //65k mode
	LCD_WR_DATA(0x05);
	LCD_WR_REG(0x29); //Display on
  LCD_direction(USE_HORIZONTAL);//LCDʾ
	LCD_LED=1;//	 
	LCD_Clear(WHITE);//ȫɫ
}
 
/*****************************************************************************
 * @name       :void LCD_SetWindows(u16 xStar, u16 yStar,u16 xEnd,u16 yEnd)
 * @date       :2018-08-09 
 * @function   :Setting LCD display window
 * @parameters :xStar:the bebinning x coordinate of the LCD display window
								yStar:the bebinning y coordinate of the LCD display window
								xEnd:the endning x coordinate of the LCD display window
								yEnd:the endning y coordinate of the LCD display window
 * @retvalue   :None
******************************************************************************/ 
void LCD_SetWindows(u16 xStar, u16 yStar,u16 xEnd,u16 yEnd)
{	
	LCD_WR_REG(lcddev.setxcmd);	
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(xStar);		
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(xEnd);

	LCD_WR_REG(lcddev.setycmd);	
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(yStar);		
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(yEnd);

	LCD_WriteRAM_Prepare();	//ʼдGRAM			
}   

/*****************************************************************************
 * @name       :void LCD_SetCursor(u16 Xpos, u16 Ypos)
 * @date       :2018-08-09 
 * @function   :Set coordinate value
 * @parameters :Xpos:the  x coordinate of the pixel
								Ypos:the  y coordinate of the pixel
 * @retvalue   :None
******************************************************************************/ 
void LCD_SetCursor(u16 Xpos, u16 Ypos)
{	  	    			
	LCD_SetWindows(Xpos,Ypos,Xpos,Ypos);	
} 

/*****************************************************************************
 * @name       :void LCD_direction(u8 direction)
 * @date       :2018-08-09 
 * @function   :Setting the display direction of LCD screen
 * @parameters :direction:0-0 degree
                          1-90 degree
													2-180 degree
													3-270 degree
 * @retvalue   :None
******************************************************************************/ 
void LCD_direction(u8 direction)
{ 
	lcddev.setxcmd=0x2A;
	lcddev.setycmd=0x2B;
	lcddev.wramcmd=0x2C;
	switch(direction){		  
		case 0:						 	 		
			lcddev.width=LCD_W;
			lcddev.height=LCD_H;		
			LCD_WriteReg(0x36,(0<<3)|(1<<6)|(1<<7));//BGR==1,MY==0,MX==0,MV==0
		break;
		case 1:
			lcddev.width=LCD_H;
			lcddev.height=LCD_W;
			LCD_WriteReg(0x36,(0<<3)|(1<<7)|(1<<5));//BGR==1,MY==1,MX==0,MV==1
		break;
		case 2:						 	 		
			lcddev.width=LCD_W;
			lcddev.height=LCD_H;	
			LCD_WriteReg(0x36,(0<<3)|(0<<6)|(0<<7));//BGR==1,MY==0,MX==0,MV==0
		break;
		case 3:
			lcddev.width=LCD_H;
			lcddev.height=LCD_W;
			LCD_WriteReg(0x36,(0<<3)|(0<<7)|(1<<6)|(1<<5));//BGR==1,MY==1,MX==0,MV==1
		break;	
		default:break;
	}		
}
