#ifndef __FONT_H
#define __FONT_H 

#ifdef __AVR__
#include <avr/pgmspace.h>
#elif defined(ESP8266)
#include <pgmspace.h>
#else
#define PROGMEM
#endif

typedef struct 
{
  unsigned char Index[2]; 
  char Msk[32];
}typFNT_GB16; 

//宋体
//16*16大小
//逐行式，顺位（高位在前）
const typFNT_GB16 cfont16[] PROGMEM = 
{
  "全",0x01,0x00,0x01,0x00,0x02,0x80,0x04,0x40,0x08,0x20,0x10,0x10,0x2F,0xE8,0xC1,0x06,
  0x01,0x00,0x01,0x00,0x1F,0xF0,0x01,0x00,0x01,0x00,0x01,0x00,0x7F,0xFC,0x00,0x00,/*"全",0*/
  "动",0x00,0x40,0x00,0x40,0x7C,0x40,0x00,0x40,0x01,0xFC,0x00,0x44,0xFE,0x44,0x20,0x44,
  0x20,0x44,0x20,0x84,0x48,0x84,0x44,0x84,0xFD,0x04,0x45,0x04,0x02,0x28,0x04,0x10,/*"动",1*/
  "电",0x01,0x00,0x01,0x00,0x01,0x00,0x3F,0xF8,0x21,0x08,0x21,0x08,0x21,0x08,0x3F,0xF8,
  0x21,0x08,0x21,0x08,0x21,0x08,0x3F,0xF8,0x21,0x0A,0x01,0x02,0x01,0x02,0x00,0xFE,/*"电",0*/
  "子",0x00,0x00,0x7F,0xF8,0x00,0x10,0x00,0x20,0x00,0x40,0x01,0x80,0x01,0x00,0xFF,0xFE,
  0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x05,0x00,0x02,0x00,/*"子",1*/
  "技",0x10,0x20,0x10,0x20,0x10,0x20,0x13,0xFE,0xFC,0x20,0x10,0x20,0x10,0x20,0x15,0xFC,
  0x18,0x84,0x30,0x88,0xD0,0x48,0x10,0x50,0x10,0x20,0x10,0x50,0x51,0x88,0x26,0x06,/*"技",2*/
  "术",0x01,0x00,0x01,0x20,0x01,0x10,0x01,0x10,0x7F,0xFC,0x03,0x80,0x05,0x40,0x05,0x40,
  0x09,0x20,0x11,0x10,0x21,0x08,0x41,0x04,0x81,0x02,0x01,0x00,0x01,0x00,0x01,0x00,/*"术",3*/ 
};

typedef struct 
{
  unsigned char Index[2]; 
  char Msk[72];
}typFNT_GB24; 

//宋体
//24*24大小
//逐行式，顺位（高位在前）
const typFNT_GB24 cfont24[] PROGMEM = 
{
  "全",0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x30,0x00,0x00,0x68,0x00,0x00,
  0x44,0x00,0x00,0xC2,0x00,0x01,0x81,0x00,0x03,0x00,0xC0,0x06,0x00,0x70,0x0F,0xFF,
  0xFE,0x10,0x18,0x08,0x60,0x18,0x00,0x00,0x18,0x00,0x00,0x18,0x00,0x00,0x18,0x60,
  0x03,0xFF,0x80,0x00,0x18,0x00,0x00,0x18,0x00,0x00,0x18,0x00,0x00,0x18,0x08,0x1F,
  0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,/*"全",0*/
  "动",0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x00,0x01,0x00,0x00,0x61,0x00,0x3F,
  0x81,0x00,0x00,0x01,0x00,0x00,0x01,0x0C,0x00,0x07,0xFC,0x00,0x31,0x0C,0x3F,0xC1,
  0x0C,0x06,0x01,0x0C,0x04,0x01,0x0C,0x0C,0x81,0x08,0x08,0x43,0x08,0x10,0x62,0x08,
  0x10,0x22,0x08,0x2F,0xF4,0x08,0x38,0x14,0x08,0x00,0x08,0x08,0x00,0x11,0x18,0x00,
  0x20,0xF8,0x00,0x40,0x30,0x00,0x00,0x00,/*"动",1*/
  "电",0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x10,0x00,0x00,0x10,0x00,0x00,
  0x10,0x00,0x0F,0xFF,0xF0,0x08,0x10,0x20,0x08,0x10,0x20,0x08,0x10,0x20,0x08,0x10,
  0x20,0x0F,0xFF,0xE0,0x08,0x10,0x20,0x08,0x10,0x20,0x08,0x10,0x20,0x08,0x10,0x20,
  0x0F,0xFF,0xE0,0x08,0x10,0x00,0x00,0x10,0x08,0x00,0x10,0x08,0x00,0x10,0x04,0x00,
  0x18,0x0C,0x00,0x0F,0xF8,0x00,0x00,0x00,/*"电",2*/
  "子",0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x0F,0xFF,0xF0,0x00,0x00,0x60,0x00,
  0x00,0x80,0x00,0x03,0x00,0x00,0x14,0x00,0x00,0x18,0x00,0x00,0x18,0x00,0x00,0x18,
  0x0C,0x7F,0xFF,0xFE,0x00,0x18,0x00,0x00,0x18,0x00,0x00,0x18,0x00,0x00,0x18,0x00,
  0x00,0x18,0x00,0x00,0x18,0x00,0x00,0x18,0x00,0x00,0x18,0x00,0x00,0x18,0x00,0x00,
  0xF8,0x00,0x00,0x30,0x00,0x00,0x00,0x00,/*"子",3*/
  "技",0x00,0x00,0x00,0x04,0x00,0x00,0x07,0x01,0x80,0x06,0x01,0x00,0x06,0x01,0x00,0x06,
  0x01,0x00,0x06,0xC1,0x0C,0x3F,0x3F,0xF0,0x06,0x01,0x00,0x06,0x01,0x00,0x06,0x01,
  0x00,0x06,0xFF,0xF8,0x07,0x08,0x10,0x3E,0x08,0x30,0x26,0x04,0x20,0x06,0x04,0x60,
  0x06,0x02,0x40,0x06,0x02,0xC0,0x06,0x01,0x80,0x06,0x03,0x80,0x06,0x0C,0x60,0x1E,
  0x10,0x3E,0x0C,0xE0,0x0C,0x00,0x00,0x00,/*"技",4*/
  "术",0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x19,0x80,0x00,0x18,0xE0,0x00,
  0x18,0x60,0x00,0x18,0x28,0x00,0x18,0x1C,0x3F,0xFF,0xE0,0x00,0x3C,0x00,0x00,0x7C,
  0x00,0x00,0x5A,0x00,0x00,0xDA,0x00,0x00,0x99,0x00,0x01,0x19,0x80,0x03,0x18,0xC0,
  0x06,0x18,0x60,0x04,0x18,0x38,0x08,0x18,0x1E,0x30,0x18,0x08,0x40,0x18,0x00,0x00,
  0x18,0x00,0x00,0x18,0x00,0x00,0x00,0x00,/*"术",5*/
};

typedef struct 
{
       unsigned char Index[2];  
       char Msk[128];
}typFNT_GB32; 

//宋体
//32*32大小
//逐行式，顺位（高位在前）
const typFNT_GB32 cfont32[] PROGMEM = 
{
  "全",0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x03,0x80,0x00,
  0x00,0x07,0x80,0x00,0x00,0x06,0x80,0x00,0x00,0x0C,0x40,0x00,0x00,0x1C,0x20,0x00,
  0x00,0x18,0x30,0x00,0x00,0x30,0x18,0x00,0x00,0x60,0x0C,0x00,0x00,0xC0,0x07,0x00,
  0x01,0x80,0x03,0xC0,0x03,0x00,0x02,0xF8,0x07,0xFF,0xFF,0x7C,0x08,0x01,0x80,0x90,
  0x30,0x01,0x80,0x00,0x40,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x81,0x00,
  0x00,0x01,0x83,0x80,0x01,0xFF,0xFF,0xC0,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,
  0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x10,
  0x00,0x01,0x80,0x38,0x1F,0xFF,0xFF,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,/*"全",0*/
  "动",0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x0E,0x00,
  0x00,0x00,0x0C,0x00,0x00,0x0C,0x0C,0x00,0x3F,0xFE,0x0C,0x00,0x10,0x00,0x0C,0x00,
  0x00,0x00,0x0C,0x00,0x00,0x00,0x0C,0x18,0x00,0x00,0xFF,0xFC,0x00,0x02,0x0C,0x18,
  0x00,0x07,0x0C,0x18,0x3F,0xFF,0x8C,0x18,0x01,0xC0,0x0C,0x18,0x01,0xC0,0x0C,0x18,
  0x01,0x80,0x08,0x18,0x03,0x00,0x08,0x18,0x02,0x10,0x18,0x18,0x06,0x08,0x18,0x18,
  0x04,0x0C,0x10,0x18,0x08,0x06,0x10,0x18,0x10,0x06,0x30,0x10,0x2F,0xFB,0x20,0x10,
  0x3E,0x03,0x60,0x10,0x10,0x02,0xC0,0x30,0x00,0x00,0x80,0x30,0x00,0x01,0x0C,0x30,
  0x00,0x02,0x03,0xE0,0x00,0x0C,0x01,0xE0,0x00,0x10,0x00,0x80,0x00,0x00,0x00,0x00,/*"动",1*/
  "电",0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x03,0x80,0x00,
  0x00,0x03,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x03,0x00,0x00,
  0x07,0xFF,0xFF,0xC0,0x06,0x03,0x00,0xC0,0x06,0x03,0x00,0xC0,0x06,0x03,0x00,0xC0,
  0x06,0x03,0x00,0xC0,0x06,0x03,0x00,0xC0,0x06,0x03,0x00,0xC0,0x07,0xFF,0xFF,0xC0,
  0x06,0x03,0x00,0xC0,0x06,0x03,0x00,0xC0,0x06,0x03,0x00,0xC0,0x06,0x03,0x00,0xC0,
  0x06,0x03,0x00,0xC0,0x07,0xFF,0xFF,0xC0,0x06,0x03,0x00,0x80,0x06,0x03,0x00,0x00,
  0x00,0x03,0x00,0x10,0x00,0x03,0x00,0x08,0x00,0x03,0x00,0x08,0x00,0x03,0x00,0x18,
  0x00,0x03,0x80,0x1C,0x00,0x01,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,/*"电",2*/
  "子",0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,
  0x03,0xFF,0xFF,0xE0,0x00,0x00,0x01,0xE0,0x00,0x00,0x03,0x00,0x00,0x00,0x06,0x00,
  0x00,0x00,0x18,0x00,0x00,0x00,0x30,0x00,0x00,0x01,0xC0,0x00,0x00,0x01,0xC0,0x00,
  0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x10,0x00,0x01,0x80,0x38,0x3F,0xFF,0xFF,0xFC,
  0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,
  0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,
  0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,
  0x00,0x3F,0x80,0x00,0x00,0x07,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,/*"子",3*/
  "技",0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x08,0x00,0x01,0xC0,0x0E,0x00,
  0x01,0x80,0x0C,0x00,0x01,0x80,0x0C,0x00,0x01,0x80,0x0C,0x00,0x01,0x80,0x0C,0x00,
  0x01,0x98,0x0C,0x18,0x3F,0xFF,0xFF,0xFC,0x01,0x80,0x0C,0x00,0x01,0x80,0x0C,0x00,
  0x01,0x80,0x0C,0x00,0x01,0x80,0x0C,0x00,0x01,0x8C,0x0C,0x20,0x01,0xB3,0xFF,0xF0,
  0x01,0xC0,0x80,0x60,0x0F,0x80,0x80,0x60,0x3D,0x80,0x40,0xC0,0x31,0x80,0x40,0xC0,
  0x01,0x80,0x21,0x80,0x01,0x80,0x21,0x80,0x01,0x80,0x33,0x00,0x01,0x80,0x1E,0x00,
  0x01,0x80,0x0C,0x00,0x01,0x80,0x1E,0x00,0x01,0x80,0x37,0x00,0x01,0x80,0xE3,0xC0,
  0x1F,0x83,0x80,0xF8,0x07,0x8E,0x00,0x7C,0x02,0x30,0x00,0x00,0x00,0x00,0x00,0x00,/*"技",4*/
  "术",0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0xC0,0x00,
  0x00,0x01,0x8C,0x00,0x00,0x01,0x87,0x00,0x00,0x01,0x83,0x80,0x00,0x01,0x81,0x80,
  0x00,0x01,0x80,0x80,0x00,0x01,0x80,0x30,0x3F,0xFF,0xFF,0xF8,0x10,0x03,0xC0,0x00,
  0x00,0x07,0xC0,0x00,0x00,0x07,0xA0,0x00,0x00,0x0D,0xA0,0x00,0x00,0x0D,0x90,0x00,
  0x00,0x19,0x90,0x00,0x00,0x19,0x98,0x00,0x00,0x31,0x8C,0x00,0x00,0x61,0x86,0x00,
  0x00,0xC1,0x87,0x00,0x00,0x81,0x83,0x80,0x01,0x81,0x81,0xC0,0x03,0x01,0x80,0xF0,
  0x04,0x01,0x80,0x7C,0x08,0x01,0x80,0x38,0x10,0x01,0x80,0x10,0x60,0x01,0x80,0x00,
  0x00,0x01,0x80,0x00,0x00,0x01,0x80,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,/*"术",5*/
};

#endif
